/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.security;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.security.RestrictedMethodAuthorizer;

public final class RegExMethodAuthorizer
implements MethodInvocationAuthorizer {
    private static final String GEODE_BASE_PACKAGE = "org.apache.geode";
    static final String NULL_CACHE_MESSAGE = "Cache should be provided to configure this authorizer.";
    static final String NULL_AUTHORIZER_MESSAGE = "RestrictedMethodAuthorizer should be provided to create this authorizer.";
    static final String NULL_REGULAR_EXPRESSIONS_MESSAGE = "A set of regular expression should be provided to configure this authorizer.";
    private final Set<String> allowedPatterns;
    private final Set<Pattern> compiledPatterns;
    private final RestrictedMethodAuthorizer restrictedMethodAuthorizer;

    private Set<Pattern> compilePatterns() {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        this.allowedPatterns.forEach(regEx -> patterns.add(Pattern.compile(regEx)));
        return patterns;
    }

    public Set<String> getAllowedPatterns() {
        return this.allowedPatterns;
    }

    public RegExMethodAuthorizer(Cache cache, Set<String> allowedPatterns) {
        Objects.requireNonNull(cache, NULL_CACHE_MESSAGE);
        Objects.requireNonNull(allowedPatterns, NULL_REGULAR_EXPRESSIONS_MESSAGE);
        this.allowedPatterns = Collections.unmodifiableSet(allowedPatterns);
        this.compiledPatterns = Collections.unmodifiableSet(this.compilePatterns());
        this.restrictedMethodAuthorizer = new RestrictedMethodAuthorizer(cache);
    }

    public RegExMethodAuthorizer(RestrictedMethodAuthorizer restrictedMethodAuthorizer, Set<String> allowedPatterns) {
        Objects.requireNonNull(allowedPatterns, NULL_REGULAR_EXPRESSIONS_MESSAGE);
        Objects.requireNonNull(restrictedMethodAuthorizer, NULL_AUTHORIZER_MESSAGE);
        this.allowedPatterns = Collections.unmodifiableSet(allowedPatterns);
        this.compiledPatterns = Collections.unmodifiableSet(this.compilePatterns());
        this.restrictedMethodAuthorizer = restrictedMethodAuthorizer;
    }

    @Override
    public boolean authorize(Method method, Object target) {
        if (this.restrictedMethodAuthorizer.isPermanentlyForbiddenMethod(method, target)) {
            return false;
        }
        if (target.getClass().getPackage().getName().startsWith(GEODE_BASE_PACKAGE)) {
            return this.restrictedMethodAuthorizer.isAllowedGeodeMethod(method, target);
        }
        String fullyQualifiedMethodName = target.getClass().getName() + "." + method.getName();
        if (this.compiledPatterns.stream().anyMatch(pattern -> pattern.matcher(fullyQualifiedMethodName).matches())) {
            return true;
        }
        return this.restrictedMethodAuthorizer.authorize(method, target);
    }
}

