/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.partition;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.cache.partition.PartitionRegionInfo;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalDataSet;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.control.RebalanceResultsImpl;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.rebalance.ExplicitMoveDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.PercentageMoveDirector;

public final class PartitionRegionHelper {
    private PartitionRegionHelper() {
    }

    public static Map<String, Region<?, ?>> getColocatedRegions(Region<?, ?> r) {
        Map<String, Region> ret;
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            ret = ColocationHelper.getAllColocationRegions(pr);
            if (ret.isEmpty()) {
                ret = Collections.emptyMap();
            }
        } else if (r instanceof LocalDataSet) {
            LocalDataSet lds = (LocalDataSet)r;
            InternalRegionFunctionContext fc = lds.getFunctionContext();
            if (fc != null) {
                ret = ColocationHelper.getAllColocatedLocalDataSets(lds.getProxy(), fc);
                if (ret.isEmpty()) {
                    ret = Collections.emptyMap();
                }
            } else {
                ret = ColocationHelper.getColocatedLocalDataSetsForBuckets(lds.getProxy(), lds.getBucketSet());
            }
        } else {
            throw new IllegalArgumentException(String.format("Region %s is not a Partitioned Region", r.getFullPath()));
        }
        return Collections.unmodifiableMap(ret);
    }

    public static boolean isPartitionedRegion(Region<?, ?> r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 'Region' is null");
        }
        return r instanceof PartitionedRegion;
    }

    private static PartitionedRegion isPartitionedCheck(Region<?, ?> r) {
        if (!PartitionRegionHelper.isPartitionedRegion(r)) {
            throw new IllegalArgumentException(String.format("Region %s is not a Partitioned Region", r.getFullPath()));
        }
        return (PartitionedRegion)r;
    }

    public static Set<PartitionRegionInfo> getPartitionRegionInfo(Cache cache) {
        TreeSet<PartitionRegionInfo> prDetailsSet = new TreeSet<PartitionRegionInfo>();
        PartitionRegionHelper.fillInPartitionedRegionInfo((InternalCache)cache, prDetailsSet, false);
        return prDetailsSet;
    }

    public static PartitionRegionInfo getPartitionRegionInfo(Region<?, ?> region) {
        try {
            PartitionedRegion partitionedRegion = PartitionRegionHelper.isPartitionedCheck(region);
            InternalCache cache = (InternalCache)region.getCache();
            return partitionedRegion.getRedundancyProvider().buildPartitionedRegionInfo(false, cache.getInternalResourceManager().getLoadProbe());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static void fillInPartitionedRegionInfo(InternalCache cache, Set prDetailsSet, boolean internal) {
        Set<PartitionedRegion> partitionedRegions = cache.getPartitionedRegions();
        if (partitionedRegions.isEmpty()) {
            return;
        }
        for (PartitionedRegion partitionedRegion : partitionedRegions) {
            InternalPRInfo prDetails = partitionedRegion.getRedundancyProvider().buildPartitionedRegionInfo(internal, cache.getInternalResourceManager().getLoadProbe());
            if (prDetails == null) continue;
            prDetailsSet.add(prDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignBucketsToPartitions(Region<?, ?> region) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        PartitionedRegion.RecoveryLock lock = null;
        try {
            lock = pr.getRecoveryLock();
            lock.lock();
            for (int i = 0; i < PartitionRegionHelper.getNumberOfBuckets(pr); ++i) {
                pr.createBucket(i, 0, null);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static int getNumberOfBuckets(PartitionedRegion pr) {
        if (pr.isFixedPartitionedRegion()) {
            int numBuckets = 0;
            HashSet<FixedPartitionAttributesImpl> fpaSet = new HashSet<FixedPartitionAttributesImpl>(pr.getRegionAdvisor().adviseAllFixedPartitionAttributes());
            if (pr.getFixedPartitionAttributesImpl() != null) {
                fpaSet.addAll(pr.getFixedPartitionAttributesImpl());
            }
            for (FixedPartitionAttributesImpl fpa : fpaSet) {
                numBuckets += fpa.getNumBuckets();
            }
            return numBuckets;
        }
        return pr.getTotalNumberOfBuckets();
    }

    public static <K, V> DistributedMember getPrimaryMemberForKey(Region<K, V> r, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr, null, key, null, null);
        return pr.getBucketPrimary(bucketId);
    }

    public static <K, V> Set<DistributedMember> getRedundantMembersForKey(Region<K, V> r, K key) {
        DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey(r, key);
        Set<DistributedMember> owners = PartitionRegionHelper.getAllForKey(r, key);
        if (primary != null) {
            owners.remove(primary);
        }
        return Collections.unmodifiableSet(owners);
    }

    public static <K, V> Set<DistributedMember> getAllMembersForKey(Region<K, V> r, K key) {
        return Collections.unmodifiableSet(PartitionRegionHelper.getAllForKey(r, key));
    }

    private static <K, V> Set<? extends DistributedMember> getAllForKey(Region<K, V> r, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr, null, key, null, null);
        return pr.getRegionAdvisor().getBucketOwners(bucketId);
    }

    public static Map<String, Region<?, ?>> getLocalColocatedRegions(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        Map<String, Region<?, ?>> ret = rfci.getColocatedLocalDataSets();
        return ret;
    }

    public static <K, V> Region<K, V> getLocalDataForContext(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        return rfci.getLocalDataSet(r);
    }

    public static <K, V> Region<K, V> getLocalData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            Set<Integer> buckets = pr.getDataStore() != null ? pr.getDataStore().getAllLocalBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(String.format("Region %s is not a Partitioned Region", r.getFullPath()));
    }

    public static <K, V> Region<K, V> getLocalPrimaryData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr = (PartitionedRegion)r;
            Set<Integer> buckets = pr.getDataStore() != null ? pr.getDataStore().getAllLocalPrimaryBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(String.format("Region %s is not a Partitioned Region", r.getFullPath()));
    }

    public static <K> void moveBucketByKey(Region<K, ?> region, DistributedMember source, DistributedMember destination, K key) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        int bucketId = pr.getKeyInfo(key).getBucketId();
        ExplicitMoveDirector director = new ExplicitMoveDirector(key, bucketId, source, destination, region.getCache().getDistributedSystem());
        PartitionedRegionRebalanceOp rebalance = new PartitionedRegionRebalanceOp(pr, false, director, true, true);
        rebalance.execute();
    }

    public static RebalanceResults moveData(Region<?, ?> region, DistributedMember source, DistributedMember destination, float percentage) {
        PartitionedRegion pr = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        if (percentage <= 0.0f || (double)percentage > 100.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100");
        }
        PercentageMoveDirector director = new PercentageMoveDirector(source, destination, percentage);
        PartitionedRegionRebalanceOp rebalance = new PartitionedRegionRebalanceOp(pr, false, director, true, true);
        Set<PartitionRebalanceInfo> results = rebalance.execute();
        RebalanceResultsImpl rebalanceResults = new RebalanceResultsImpl();
        for (PartitionRebalanceInfo details : results) {
            rebalanceResults.addDetails(details);
        }
        return rebalanceResults;
    }
}

