/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.annotations.Immutable;

@Immutable
public class DataPolicy
implements Serializable {
    private static final long serialVersionUID = 2095573273889467233L;
    @Immutable
    private static final DataPolicy[] VALUES = new DataPolicy[11];
    @Immutable
    private static final String[] NAMES = new String[VALUES.length];
    @Immutable
    public static final DataPolicy EMPTY = new DataPolicy(0, "EMPTY");
    @Immutable
    public static final DataPolicy NORMAL = new DataPolicy(1, "NORMAL");
    @Immutable
    public static final DataPolicy REPLICATE = new DataPolicy(2, "REPLICATE");
    @Immutable
    public static final DataPolicy PERSISTENT_REPLICATE = new DataPolicy(3, "PERSISTENT_REPLICATE");
    @Immutable
    public static final DataPolicy PARTITION = new DataPolicy(4, "PARTITION");
    @Immutable
    public static final DataPolicy PRELOADED = new DataPolicy(5, "PRELOADED");
    @Immutable
    public static final DataPolicy PERSISTENT_PARTITION = new DataPolicy(6, "PERSISTENT_PARTITION");
    @Immutable
    public static final DataPolicy DEFAULT = NORMAL;
    private final transient String name;
    @Deprecated
    public final byte ordinal;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private DataPolicy(int ordinal, String name) {
        if (ordinal >= VALUES.length) {
            throw new IllegalArgumentException(String.format("Only %s DataPolicies may be defined", VALUES.length + 1));
        }
        if (VALUES[ordinal] != null) {
            throw new IllegalArgumentException(String.format("Ordinal %s is already defined by %s", ordinal, VALUES[ordinal]));
        }
        this.name = name;
        this.ordinal = (byte)(ordinal & 0xFF);
        DataPolicy.VALUES[this.ordinal] = this;
        DataPolicy.NAMES[this.ordinal] = name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static DataPolicy valueOf(String name) throws IllegalArgumentException {
        if (null == name) {
            throw new NullPointerException();
        }
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(name)) continue;
            return VALUES[i];
        }
        throw new IllegalArgumentException(name);
    }

    public static DataPolicy fromOrdinal(byte ordinal) {
        return VALUES[ordinal];
    }

    public boolean withStorage() {
        return this != EMPTY;
    }

    public boolean withReplication() {
        return this == REPLICATE || this == PERSISTENT_REPLICATE;
    }

    public boolean withPersistence() {
        return this == PERSISTENT_PARTITION || this == PERSISTENT_REPLICATE;
    }

    public boolean withPartitioning() {
        return this == PARTITION || this == PERSISTENT_PARTITION;
    }

    public boolean withPreloaded() {
        return this == PRELOADED;
    }

    @Deprecated
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Deprecated
    public boolean isNormal() {
        return this == NORMAL;
    }

    @Deprecated
    public boolean isPreloaded() {
        return this == PRELOADED;
    }

    @Deprecated
    public boolean isDefault() {
        return this == DEFAULT;
    }

    @Deprecated
    public boolean isReplicate() {
        return this == REPLICATE;
    }

    @Deprecated
    public boolean isPersistentReplicate() {
        return this == PERSISTENT_REPLICATE;
    }

    @Deprecated
    public boolean isPartition() {
        return this == PARTITION;
    }

    public String toString() {
        return this.name;
    }

    @Deprecated
    public static DataPolicy fromString(String s) {
        try {
            return DataPolicy.valueOf(s);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }
}

