/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;
    private final boolean includeSpanScore;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function, boolean includeSpanScore) {
        this.wrappedQuery = Objects.requireNonNull(wrappedQuery);
        this.function = Objects.requireNonNull(function);
        this.includeSpanScore = includeSpanScore;
    }

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function) {
        this(wrappedQuery, function, true);
    }

    public String getField() {
        return this.wrappedQuery.getField();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query matchRewritten = this.wrappedQuery.rewrite(reader);
        if (this.wrappedQuery != matchRewritten && matchRewritten instanceof SpanQuery) {
            return new PayloadScoreQuery((SpanQuery)matchRewritten, this.function, this.includeSpanScore);
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("PayloadScoreQuery(");
        buffer.append(this.wrappedQuery.toString(field));
        buffer.append(", function: ");
        buffer.append(this.function.getClass().getSimpleName());
        buffer.append(", includeSpanScore: ");
        buffer.append(this.includeSpanScore);
        buffer.append(")");
        return buffer.toString();
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, needsScores);
        if (!needsScores) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PayloadScoreQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(PayloadScoreQuery other) {
        return this.wrappedQuery.equals((Object)other.wrappedQuery) && this.function.equals(other.function) && this.includeSpanScore == other.includeSpanScore;
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.wrappedQuery);
        result = 31 * result + Objects.hashCode(this.function);
        result = 31 * result + Objects.hashCode(this.includeSpanScore);
        return result;
    }

    private class PayloadSpanScorer
    extends SpanScorer {
        private final PayloadSpans spans;

        private PayloadSpanScorer(SpanWeight weight, PayloadSpans spans, Similarity.SimScorer docScorer) throws IOException {
            super(weight, (Spans)spans, docScorer);
            this.spans = spans;
        }

        protected float getPayloadScore() {
            return PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
        }

        protected Explanation getPayloadExplanation() {
            return PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.spans.payloadsSeen, this.spans.payloadScore);
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        protected float scoreCurrentDoc() throws IOException {
            if (PayloadScoreQuery.this.includeSpanScore) {
                return this.getSpanScore() * this.getPayloadScore();
            }
            return this.getPayloadScore();
        }
    }

    private class PayloadSpans
    extends FilterSpans
    implements SpanCollector {
        private final Similarity.SimScorer docScorer;
        public int payloadsSeen;
        public float payloadScore;

        private PayloadSpans(Spans in, Similarity.SimScorer docScorer) {
            super(in);
            this.docScorer = docScorer;
        }

        protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
            return FilterSpans.AcceptStatus.YES;
        }

        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            if (payload == null) {
                return;
            }
            float payloadFactor = this.docScorer.computePayloadFactor(this.docID(), this.in.startPosition(), this.in.endPosition(), payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.in.startPosition(), this.in.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        public void reset() {
        }

        protected void doCurrentSpans() throws IOException {
            this.in.collect((SpanCollector)this);
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight) throws IOException {
            super((SpanQuery)PayloadScoreQuery.this, searcher, null);
            this.innerWeight = innerWeight;
        }

        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.innerWeight.extractTermContexts(contexts);
        }

        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        public SpanScorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            Similarity.SimScorer docScorer = this.innerWeight.getSimScorer(context);
            PayloadSpans payloadSpans = new PayloadSpans(spans, docScorer);
            return new PayloadSpanScorer(this, payloadSpans, docScorer);
        }

        public void extractTerms(Set<Term> terms) {
            this.innerWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.innerWeight.getValueForNormalization();
        }

        public void normalize(float queryNorm, float topLevelBoost) {
            this.innerWeight.normalize(queryNorm, topLevelBoost);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            PayloadSpanScorer scorer = (PayloadSpanScorer)this.scorer(context);
            if (scorer == null || scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch((String)"No match", (Explanation[])new Explanation[0]);
            }
            scorer.freq();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            if (PayloadScoreQuery.this.includeSpanScore) {
                SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
                Explanation innerExpl = innerWeight.explain(context, doc);
                return Explanation.match((float)scorer.scoreCurrentDoc(), (String)"PayloadSpanQuery, product of:", (Explanation[])new Explanation[]{innerExpl, payloadExpl});
            }
            return scorer.getPayloadExplanation();
        }
    }
}

