/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.file.predicate.CompoundPredicate;
import org.apache.flink.table.store.file.predicate.Equal;
import org.apache.flink.table.store.file.predicate.GreaterOrEqual;
import org.apache.flink.table.store.file.predicate.GreaterThan;
import org.apache.flink.table.store.file.predicate.IsNotNull;
import org.apache.flink.table.store.file.predicate.IsNull;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.LeafPredicate;
import org.apache.flink.table.store.file.predicate.LessOrEqual;
import org.apache.flink.table.store.file.predicate.LessThan;
import org.apache.flink.table.store.file.predicate.NotEqual;
import org.apache.flink.table.store.file.predicate.Or;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.TriFunction;

public class OrcFilterConverter {
    private static final ImmutableMap<Class<? extends LeafFunction>, Function<LeafPredicate, OrcFilters.Predicate>> FILTERS = new ImmutableMap.Builder().put(IsNull.class, OrcFilterConverter::convertIsNull).put(IsNotNull.class, OrcFilterConverter::convertIsNotNull).put(Equal.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertEquals))).put(NotEqual.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertNotEquals))).put(GreaterThan.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertGreaterThan))).put(GreaterOrEqual.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertGreaterThanEquals))).put(LessThan.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertLessThan))).put(LessOrEqual.class, call -> OrcFilterConverter.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate>)((TriFunction)OrcFilterConverter::convertLessThanEquals))).build();

    private static OrcFilters.Predicate convertIsNull(LeafPredicate predicate) {
        PredicateLeaf.Type colType = OrcFilterConverter.toOrcType(predicate.type());
        if (colType == null) {
            return null;
        }
        return new OrcFilters.IsNull(predicate.fieldName(), colType);
    }

    private static OrcFilters.Predicate convertIsNotNull(LeafPredicate predicate) {
        OrcFilters.Predicate isNull = OrcFilterConverter.convertIsNull(predicate);
        if (isNull == null) {
            return null;
        }
        return new OrcFilters.Not(isNull);
    }

    private static OrcFilters.Predicate convertOr(CompoundPredicate or) {
        if (or.children().size() != 2) {
            throw new RuntimeException("Illegal or children: " + or.children().size());
        }
        OrcFilters.Predicate c1 = OrcFilterConverter.toOrcPredicate(or.children().get(0));
        if (c1 == null) {
            return null;
        }
        OrcFilters.Predicate c2 = OrcFilterConverter.toOrcPredicate(or.children().get(1));
        if (c2 == null) {
            return null;
        }
        return new OrcFilters.Or(c1, c2);
    }

    private static OrcFilters.Predicate convertBinary(LeafPredicate predicate, TriFunction<String, PredicateLeaf.Type, Serializable, OrcFilters.Predicate> func) {
        PredicateLeaf.Type litType = OrcFilterConverter.toOrcType(predicate.type());
        if (litType == null) {
            return null;
        }
        String colName = predicate.fieldName();
        Object orcObj = OrcFilterConverter.toOrcObject(litType, predicate.literals().get(0));
        if (!(orcObj instanceof Serializable)) {
            return null;
        }
        Serializable literal = (Serializable)orcObj;
        return (OrcFilters.Predicate)func.apply((Object)colName, (Object)litType, (Object)literal);
    }

    private static OrcFilters.Predicate convertEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.Equals(colName, litType, literal);
    }

    private static OrcFilters.Predicate convertNotEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.Not(OrcFilterConverter.convertEquals(colName, litType, literal));
    }

    private static OrcFilters.Predicate convertGreaterThan(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.Not(new OrcFilters.LessThanEquals(colName, litType, literal));
    }

    private static OrcFilters.Predicate convertGreaterThanEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.Not(new OrcFilters.LessThan(colName, litType, literal));
    }

    private static OrcFilters.Predicate convertLessThan(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.LessThan(colName, litType, literal);
    }

    private static OrcFilters.Predicate convertLessThanEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new OrcFilters.LessThanEquals(colName, litType, literal);
    }

    @Nullable
    public static OrcFilters.Predicate toOrcPredicate(Predicate expression) {
        if (expression instanceof CompoundPredicate) {
            CompoundPredicate compound = (CompoundPredicate)expression;
            if (compound.function().equals(Or.INSTANCE)) {
                return OrcFilterConverter.convertOr(compound);
            }
        } else if (expression instanceof LeafPredicate) {
            LeafPredicate leaf = (LeafPredicate)expression;
            Function function = (Function)FILTERS.get(leaf.function().getClass());
            if (function == null) {
                return null;
            }
            return (OrcFilters.Predicate)function.apply(leaf);
        }
        return null;
    }

    @Nullable
    private static Object toOrcObject(PredicateLeaf.Type litType, Object literalObj) {
        if (literalObj == null) {
            return null;
        }
        switch (litType) {
            case STRING: {
                return literalObj.toString();
            }
            case DECIMAL: {
                return ((DecimalData)literalObj).toBigDecimal();
            }
            case DATE: {
                return Date.valueOf(LocalDate.ofEpochDay(((Number)literalObj).longValue()));
            }
            case TIMESTAMP: {
                return ((TimestampData)literalObj).toTimestamp();
            }
        }
        return literalObj;
    }

    @Nullable
    private static PredicateLeaf.Type toOrcType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return PredicateLeaf.Type.LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return PredicateLeaf.Type.FLOAT;
            }
            case BOOLEAN: {
                return PredicateLeaf.Type.BOOLEAN;
            }
            case CHAR: 
            case VARCHAR: {
                return PredicateLeaf.Type.STRING;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            case DATE: {
                return PredicateLeaf.Type.DATE;
            }
            case DECIMAL: {
                return PredicateLeaf.Type.DECIMAL;
            }
        }
        return null;
    }
}

