/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.export;

import com.google.common.base.Preconditions;
import io.opencensus.implcore.trace.RecordEventsSpanImpl;
import io.opencensus.implcore.trace.internal.ConcurrentIntrusiveList;
import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SpanData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class InProcessRunningSpanStore
extends RunningSpanStore {
    private static final RunningSpanStore.Summary EMPTY_SUMMARY = RunningSpanStore.Summary.create(Collections.emptyMap());
    @Nullable
    private volatile InProcessRunningSpanStoreImpl impl = null;

    static InProcessRunningSpanStore create() {
        return new InProcessRunningSpanStore();
    }

    public void onStart(RecordEventsSpanImpl span) {
        InProcessRunningSpanStoreImpl impl = this.impl;
        if (impl != null) {
            impl.onStart(span);
        }
    }

    public void onEnd(RecordEventsSpanImpl span) {
        InProcessRunningSpanStoreImpl impl = this.impl;
        if (impl != null) {
            impl.onEnd(span);
        }
    }

    public boolean getEnabled() {
        return this.impl != null;
    }

    @Override
    public RunningSpanStore.Summary getSummary() {
        InProcessRunningSpanStoreImpl impl = this.impl;
        if (impl != null) {
            return impl.getSummary();
        }
        return EMPTY_SUMMARY;
    }

    @Override
    public Collection<SpanData> getRunningSpans(RunningSpanStore.Filter filter) {
        InProcessRunningSpanStoreImpl impl = this.impl;
        if (impl != null) {
            return impl.getRunningSpans(filter);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxNumberOfSpans(int maxNumberOfSpans) {
        Preconditions.checkArgument(maxNumberOfSpans >= 0, "Invalid negative maxNumberOfElements");
        InProcessRunningSpanStore inProcessRunningSpanStore = this;
        synchronized (inProcessRunningSpanStore) {
            InProcessRunningSpanStoreImpl currentImpl = this.impl;
            if (currentImpl != null) {
                currentImpl.clear();
            }
            this.impl = null;
            if (maxNumberOfSpans > 0) {
                this.impl = new InProcessRunningSpanStoreImpl(maxNumberOfSpans);
            }
        }
    }

    private static final class InProcessRunningSpanStoreImpl {
        private final ConcurrentIntrusiveList<RecordEventsSpanImpl> runningSpans;

        private InProcessRunningSpanStoreImpl(int maxNumberOfElements) {
            this.runningSpans = new ConcurrentIntrusiveList(maxNumberOfElements);
        }

        private void onStart(RecordEventsSpanImpl span) {
            this.runningSpans.addElement(span);
        }

        private void onEnd(RecordEventsSpanImpl span) {
            this.runningSpans.removeElement(span);
        }

        private RunningSpanStore.Summary getSummary() {
            Collection<RecordEventsSpanImpl> allRunningSpans = this.runningSpans.getAll();
            HashMap<String, Integer> numSpansPerName = new HashMap<String, Integer>();
            for (RecordEventsSpanImpl span : allRunningSpans) {
                Integer prevValue = (Integer)numSpansPerName.get(span.getName());
                numSpansPerName.put(span.getName(), prevValue != null ? prevValue + 1 : 1);
            }
            HashMap<String, RunningSpanStore.PerSpanNameSummary> perSpanNameSummary = new HashMap<String, RunningSpanStore.PerSpanNameSummary>();
            for (Map.Entry it : numSpansPerName.entrySet()) {
                perSpanNameSummary.put((String)it.getKey(), RunningSpanStore.PerSpanNameSummary.create((Integer)it.getValue()));
            }
            return RunningSpanStore.Summary.create(perSpanNameSummary);
        }

        private Collection<SpanData> getRunningSpans(RunningSpanStore.Filter filter) {
            Collection<RecordEventsSpanImpl> allRunningSpans = this.runningSpans.getAll();
            int maxSpansToReturn = filter.getMaxSpansToReturn() == 0 ? allRunningSpans.size() : filter.getMaxSpansToReturn();
            ArrayList<SpanData> ret = new ArrayList<SpanData>(maxSpansToReturn);
            for (RecordEventsSpanImpl span : allRunningSpans) {
                if (ret.size() == maxSpansToReturn) break;
                if (!span.getName().equals(filter.getSpanName())) continue;
                ret.add(span.toSpanData());
            }
            return ret;
        }

        private void clear() {
            this.runningSpans.clear();
        }
    }
}

