/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecVectorSearchTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.VectorSearchTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalVectorSearchFunction;
import org.apache.flink.table.planner.plan.utils.VectorSearchUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.util.Preconditions;

public class BatchPhysicalVectorSearchTableFunction
extends CommonPhysicalVectorSearchFunction
implements BatchPhysicalRel {
    public BatchPhysicalVectorSearchTableFunction(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelOptTable searchTable, @Nullable RexProgram projectionOnVectorTable, VectorSearchSpec vectorSearchSpec, RelDataType outputRowType) {
        super(cluster, traits, input, searchTable, projectionOnVectorTable, vectorSearchSpec, outputRowType);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new BatchPhysicalVectorSearchTableFunction(this.getCluster(), traitSet, inputs.get(0), this.searchTable, this.projectionOnVectorTable, this.vectorSearchSpec, this.outputRowType);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        TableConfig tableConfig = ShortcutUtils.unwrapTableConfig(this);
        VectorSearchTableSourceSpec sourceSpec = new VectorSearchTableSourceSpec(this.searchTable);
        ((DynamicTableSourceSpec)Preconditions.checkNotNull((Object)sourceSpec.getTableSourceSpec())).setTableSource(this.searchTable.tableSource());
        if (this.projectionOnVectorTable != null) {
            throw new UnsupportedOperationException("Don't support calc on VECTOR_SEARCH node now.");
        }
        return new BatchExecVectorSearchTableFunction((ReadableConfig)tableConfig, sourceSpec, this.vectorSearchSpec, VectorSearchUtil.isAsyncVectorSearch(this.searchTable, Optional.ofNullable(this.vectorSearchSpec.getRuntimeConfig()).orElse(Collections.emptyMap()), this.vectorSearchSpec.getSearchColumns().keySet()) ? VectorSearchUtil.getMergedVectorSearchAsyncOptions(this.vectorSearchSpec.getRuntimeConfig() == null ? Collections.emptyMap() : this.vectorSearchSpec.getRuntimeConfig(), tableConfig, ChangelogMode.insertOnly()) : null, InputProperty.DEFAULT, FlinkTypeFactory.toLogicalRowType(this.outputRowType), this.getRelDetailedDescription());
    }
}

