/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.types.Either;

public class SqlValidatorUtils {
    public static void adjustTypeForArrayConstructor(RelDataType componentType, SqlOperatorBinding opBinding) {
        if (opBinding instanceof SqlCallBinding) {
            SqlValidatorUtils.adjustTypeForMultisetConstructor(componentType, componentType, (SqlCallBinding)opBinding);
        }
    }

    public static void adjustTypeForMapConstructor(Pair<RelDataType, RelDataType> componentType, SqlOperatorBinding opBinding) {
        if (opBinding instanceof SqlCallBinding) {
            SqlValidatorUtils.adjustTypeForMultisetConstructor(componentType.getKey(), componentType.getValue(), (SqlCallBinding)opBinding);
        }
    }

    public static boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    public static boolean throwExceptionOrReturnFalse(Optional<RuntimeException> e, boolean throwOnFailure) {
        if (e.isPresent()) {
            if (throwOnFailure) {
                throw e.get();
            }
            return false;
        }
        return true;
    }

    public static boolean checkTableAndDescriptorOperands(SqlCallBinding callBinding, Integer ... descriptorLocations) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return false;
        }
        for (Integer location : descriptorLocations) {
            SqlNode operand = callBinding.operand(location);
            if (operand.getKind() != SqlKind.DESCRIPTOR) {
                return false;
            }
            SqlValidatorUtils.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand).getOperandList());
        }
        return true;
    }

    private static void validateColumnNames(SqlValidator validator, List<String> fieldNames, List<SqlNode> columnNames) {
        SqlNameMatcher matcher = validator.getCatalogReader().nameMatcher();
        for (SqlNode columnName : columnNames) {
            SqlIdentifier columnIdentifier = (SqlIdentifier)columnName;
            if (!columnIdentifier.isSimple()) {
                throw SqlUtil.newContextException(columnName.getParserPosition(), Static.RESOURCE.aliasMustBeSimpleIdentifier());
            }
            String name = columnIdentifier.getSimple();
            if (matcher.indexOf(fieldNames, name) >= 0) continue;
            throw SqlUtil.newContextException(columnName.getParserPosition(), Static.RESOURCE.unknownIdentifier(name));
        }
    }

    private static void adjustTypeForMultisetConstructor(RelDataType evenType, RelDataType oddType, SqlCallBinding sqlCallBinding) {
        SqlCall call = sqlCallBinding.getCall();
        List<RelDataType> operandTypes = sqlCallBinding.collectOperandTypes();
        List<SqlNode> operands = call.getOperandList();
        for (int i = 0; i < operands.size(); ++i) {
            RelDataType elementType = i % 2 == 0 ? evenType : oddType;
            if (operandTypes.get(i).equalsSansFieldNames(elementType)) continue;
            call.setOperand(i, SqlValidatorUtils.castTo(operands.get(i), elementType));
        }
    }

    public static List<RelDataTypeField> makeOutputUnique(List<RelDataTypeField> input, List<RelDataTypeField> output) {
        HashSet<String> uniqueNames = new HashSet<String>();
        for (RelDataTypeField field : input) {
            uniqueNames.add(field.getName());
        }
        ArrayList<RelDataTypeField> result = new ArrayList<RelDataTypeField>();
        for (RelDataTypeField field : output) {
            String fieldName = field.getName();
            int count = 0;
            Object candidate = fieldName;
            while (uniqueNames.contains(candidate)) {
                candidate = fieldName + count;
                ++count;
            }
            uniqueNames.add((String)candidate);
            result.add(new RelDataTypeFieldImpl((String)candidate, field.getIndex(), field.getType()));
        }
        return result;
    }

    public static Either<String, RuntimeException> reduceLiteralToString(SqlNode operand, SqlValidator validator) {
        if (operand instanceof SqlCharStringLiteral) {
            return Either.Left((Object)((SqlCharStringLiteral)operand).getValueAs(NlsString.class).getValue());
        }
        if (operand.getKind() == SqlKind.CAST) {
            SqlCall call = (SqlCall)operand;
            SqlDataTypeSpec dataType = (SqlDataTypeSpec)call.operand(1);
            if (!FlinkTypeFactory.toLogicalType(dataType.deriveType(validator)).is(LogicalTypeFamily.CHARACTER_STRING)) {
                return Either.Right((Object)((Object)new ValidationException("Don't support to cast value to non-string type.")));
            }
            Object operand0 = call.operand(0);
            if (operand0 instanceof SqlCharStringLiteral) {
                return Either.Left((Object)((SqlCharStringLiteral)operand0).getValueAs(NlsString.class).getValue());
            }
            return Either.Right((Object)((Object)new ValidationException(String.format("Unsupported expression %s is in runtime config at position %s. Currently, runtime config should be be a MAP of string literals.", operand, operand.getParserPosition()))));
        }
        return Either.Right((Object)((Object)new ValidationException(String.format("Unsupported expression %s is in runtime config at position %s. Currently, runtime config should be be a MAP of string literals.", operand, operand.getParserPosition()))));
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(type).withNullable(type.isNullable()));
    }
}

