/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableModify;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableTableModifyRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalTableModify.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableModificationRule").withRuleFactory(EnumerableTableModifyRule::new);

    protected EnumerableTableModifyRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        TableModify modify = (TableModify)rel;
        ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
        if (modifiableTable == null) {
            return null;
        }
        RelTraitSet traitSet = modify.getTraitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableTableModify(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), EnumerableTableModifyRule.convert(modify.getInput(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.getSourceExpressionList(), modify.isFlattened());
    }
}

