/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.adaptive;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.planner.loader.PlannerModule;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.adaptive.AdaptiveJoin;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class AdaptiveJoinOperatorFactory<OUT>
extends AbstractStreamOperatorFactory<OUT>
implements AdaptiveJoin {
    private static final long serialVersionUID = 1L;
    private final byte[] adaptiveJoinSerialized;
    @Nullable
    private transient AdaptiveJoin adaptiveJoin;
    @Nullable
    private StreamOperatorFactory<OUT> finalFactory;

    public AdaptiveJoinOperatorFactory(byte[] adaptiveJoinSerialized) {
        this.adaptiveJoinSerialized = (byte[])Preconditions.checkNotNull((Object)adaptiveJoinSerialized);
    }

    @Override
    public StreamOperatorFactory<?> genOperatorFactory(ClassLoader classLoader, ReadableConfig config) {
        this.checkAndLazyInitialize();
        this.finalFactory = this.adaptiveJoin.genOperatorFactory(classLoader, config);
        return this.finalFactory;
    }

    @Override
    public FlinkJoinType getJoinType() {
        this.checkAndLazyInitialize();
        return this.adaptiveJoin.getJoinType();
    }

    @Override
    public void markAsBroadcastJoin(boolean canBeBroadcast, boolean leftIsBuild) {
        this.checkAndLazyInitialize();
        this.adaptiveJoin.markAsBroadcastJoin(canBeBroadcast, leftIsBuild);
    }

    @Override
    public boolean shouldReorderInputs() {
        this.checkAndLazyInitialize();
        return this.adaptiveJoin.shouldReorderInputs();
    }

    private void checkAndLazyInitialize() {
        if (this.adaptiveJoin == null) {
            this.lazyInitialize();
        }
    }

    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        Preconditions.checkNotNull(this.finalFactory, (String)String.format("The OperatorFactory of task [%s] have not been initialized.", parameters.getContainingTask()));
        if (this.finalFactory instanceof AbstractStreamOperatorFactory) {
            ((AbstractStreamOperatorFactory)this.finalFactory).setProcessingTimeService(this.processingTimeService);
        }
        StreamOperator operator = this.finalFactory.createStreamOperator(parameters);
        return (T)operator;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        throw new UnsupportedOperationException("The method should not be invoked in the adaptive join operator for batch jobs.");
    }

    private void lazyInitialize() {
        boolean isSuccess;
        if (!this.tryInitializeAdaptiveJoin(Thread.currentThread().getContextClassLoader()) && !(isSuccess = this.tryInitializeAdaptiveJoin(PlannerModule.getInstance().getSubmoduleClassLoader()))) {
            throw new RuntimeException("Failed to deserialize AdaptiveJoin instance. Please check whether the flink-table-planner-loader.jar is in the classpath.");
        }
    }

    private boolean tryInitializeAdaptiveJoin(ClassLoader classLoader) {
        try {
            this.adaptiveJoin = (AdaptiveJoin)InstantiationUtil.deserializeObject((byte[])this.adaptiveJoinSerialized, (ClassLoader)classLoader);
        }
        catch (IOException | ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

