/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.util;

import com.adobe.fxg.util.FXGLocalizationUtil;
import com.adobe.fxg.util.FXGLogger;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractLogger
implements FXGLogger {
    protected int level;

    protected AbstractLogger(int level) {
        this.level = level;
    }

    public void debug(Object message) {
        this.log(10000, message);
    }

    public void debug(Object message, Throwable t) {
        this.log(10000, message, t);
    }

    public void debug(Object message, Throwable t, String location, int line, int column) {
        this.log(10000, message, t, location, line, column);
    }

    public void debug(Object message, Throwable t, String location, int line, int column, Object ... arguments) {
        this.log(10000, message, t, location, line, column, arguments);
    }

    public void error(Object message) {
        this.log(40000, message);
    }

    public void error(Object message, Throwable t) {
        this.log(40000, message, t);
    }

    public void error(Object message, Throwable t, String location, int line, int column) {
        this.log(40000, message, t, location, line, column);
    }

    public void error(Object message, Throwable t, String location, int line, int column, Object ... arguments) {
        this.log(40000, message, t, location, line, column, arguments);
    }

    public void info(Object message) {
        this.log(20000, message);
    }

    public void info(Object message, Throwable t) {
        this.log(20000, message, t);
    }

    public void info(Object message, Throwable t, String location, int line, int column) {
        this.log(20000, message, t, location, line, column);
    }

    public void info(Object message, Throwable t, String location, int line, int column, Object ... arguments) {
        this.log(20000, message, t, location, line, column, arguments);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int value) {
        this.level = value;
    }

    public void log(int level, Object message) {
        this.log(level, message, null);
    }

    public void log(int level, Object message, Throwable t) {
        this.log(level, message, t, null, 0, 0);
    }

    public void log(int level, Object message, Throwable t, String location, int line, int column) {
        this.log(level, message, t, location, line, column, null);
    }

    public void warn(Object message) {
        this.log(30000, message);
    }

    public void warn(Object message, Throwable t) {
        this.log(30000, message, t);
    }

    public void warn(Object message, Throwable t, String location, int line, int column) {
        this.log(30000, message, t, location, line, column);
    }

    public void warn(Object message, Throwable t, String location, int line, int column, Object ... arguments) {
        this.log(30000, message, t, location, line, column, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessage(String message, Object ... arguments) {
        Class<AbstractLogger> clazz = AbstractLogger.class;
        synchronized (AbstractLogger.class) {
            FXGLocalizationUtil.setLogResourceBundle(null, null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getLocalizedMessage(message, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalizedMessage(String message, Object ... arguments) {
        Class<AbstractLogger> clazz = AbstractLogger.class;
        synchronized (AbstractLogger.class) {
            ResourceBundle resourceBundle = FXGLocalizationUtil.getLogResourceBundle();
            String paramMsg = message;
            if (resourceBundle != null) {
                Enumeration<String> keys = resourceBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.equals(paramMsg)) continue;
                    paramMsg = resourceBundle.getString(message);
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return FXGLocalizationUtil.substituteArguments(paramMsg, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalizedMessage(Locale locale, String message, Object ... arguments) {
        Class<AbstractLogger> clazz = AbstractLogger.class;
        synchronized (AbstractLogger.class) {
            FXGLocalizationUtil.setLocale(locale);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.getLocalizedMessage(message, arguments);
        }
    }
}

