/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FXGLocalizationUtil {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String DEFAULT_EXCEPTION_RESOURCE_BASE_NAME = "com.adobe.fxg.FXGException";
    public static final String DEFAULT_LOG_RESOURCE_BASE_NAME = "com.adobe.fxg.FXGLog";
    private static ThreadLocal<String> logResourceBaseName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return FXGLocalizationUtil.DEFAULT_LOG_RESOURCE_BASE_NAME;
        }
    };
    private static ThreadLocal<ResourceBundle> logResourceBundle = new ThreadLocal<ResourceBundle>(){

        @Override
        protected ResourceBundle initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> exceptionResourceBaseName = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return FXGLocalizationUtil.DEFAULT_EXCEPTION_RESOURCE_BASE_NAME;
        }
    };
    private static ThreadLocal<ResourceBundle> exceptionResourceBundle = new ThreadLocal<ResourceBundle>(){

        @Override
        protected ResourceBundle initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Locale> defaultLocale = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            return DEFAULT_LOCALE;
        }
    };
    private static ThreadLocal<Locale> currentLocale = new ThreadLocal<Locale>(){

        @Override
        protected Locale initialValue() {
            return DEFAULT_LOCALE;
        }
    };

    public static String substituteArguments(String parameterized, Object[] arguments) {
        if (parameterized == null || arguments == null) {
            return parameterized;
        }
        return MessageFormat.format(parameterized, arguments).trim();
    }

    public static Locale getDefaultLocale() {
        return defaultLocale.get();
    }

    public static void setDefaultLocale(Locale loc) {
        if (loc == null) {
            loc = DEFAULT_LOCALE;
        }
        if (defaultLocale.get().equals(loc)) {
            return;
        }
        defaultLocale.set(loc);
    }

    public static Locale getLocale() {
        return currentLocale.get();
    }

    public static void setLocale(Locale loc) {
        if (loc == null) {
            loc = FXGLocalizationUtil.getDefaultLocale();
        }
        if (currentLocale.get().equals(loc)) {
            return;
        }
        currentLocale.set(loc);
        FXGLocalizationUtil.setExceptionResourceBundle();
        FXGLocalizationUtil.setLogResourceBundle();
    }

    public static void setLogResourceBundle(String baseName, Locale loc) {
        if (baseName == null) {
            baseName = DEFAULT_LOG_RESOURCE_BASE_NAME;
        }
        if (loc == null) {
            loc = FXGLocalizationUtil.getDefaultLocale();
        }
        if (logResourceBaseName.get().equals(baseName) && currentLocale.get().equals(loc) && logResourceBundle.get() != null) {
            return;
        }
        FXGLocalizationUtil.setLocale(loc);
        logResourceBaseName.set(baseName);
    }

    public static ResourceBundle getLogResourceBundle() {
        if (logResourceBundle.get() == null) {
            FXGLocalizationUtil.setLogResourceBundle();
        }
        return logResourceBundle.get();
    }

    public static void setExceptionResourceBundle(String baseName, Locale loc) {
        if (baseName == null) {
            baseName = DEFAULT_EXCEPTION_RESOURCE_BASE_NAME;
        }
        if (loc == null) {
            loc = FXGLocalizationUtil.getDefaultLocale();
        }
        if (exceptionResourceBaseName.get().equals(baseName) && currentLocale.get().equals(loc) && exceptionResourceBundle.get() != null) {
            return;
        }
        FXGLocalizationUtil.setLocale(loc);
        exceptionResourceBaseName.set(baseName);
    }

    public static void setExceptionResourceBundle() {
        try {
            exceptionResourceBundle.set(ResourceBundle.getBundle(exceptionResourceBaseName.get(), currentLocale.get()));
        }
        catch (MissingResourceException e) {
            exceptionResourceBundle = null;
        }
    }

    public static ResourceBundle getExceptionResourceBundle() {
        if (exceptionResourceBundle.get() == null) {
            FXGLocalizationUtil.setExceptionResourceBundle();
        }
        return exceptionResourceBundle.get();
    }

    public static void setLogResourceBundle() {
        try {
            logResourceBundle.set(ResourceBundle.getBundle(logResourceBaseName.get(), currentLocale.get()));
        }
        catch (MissingResourceException e) {
            logResourceBundle.set(null);
        }
    }
}

