/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.swc;

import flex2.compiler.io.FileUtil;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipOutputStream;
import flex2.compiler.util.MimeMappings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcWriteOnlyArchive
implements SwcArchive {
    protected final OutputStream out;
    protected final String name;
    protected Map<String, VirtualFile> files = new HashMap<String, VirtualFile>();

    public SwcWriteOnlyArchive(String name, OutputStream out) {
        this.out = out;
        this.name = name;
    }

    @Override
    public String getLocation() {
        return this.name;
    }

    @Override
    public void load() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(this.out);
            for (VirtualFile f : this.files.values()) {
                ZipEntry entry = new ZipEntry(f.getName());
                entry.setTime(f.getLastModified());
                zos.putNextEntry(entry);
                BufferedInputStream in = new BufferedInputStream(f.getInputStream());
                FileUtil.streamOutput(in, zos);
                zos.closeEntry();
            }
            zos.flush();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (zos != null) {
                zos.close();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void close() {
    }

    @Override
    public Map<String, VirtualFile> getFiles() {
        return this.files;
    }

    @Override
    public VirtualFile getFile(String path) {
        return this.files.get(path);
    }

    @Override
    public void putFile(VirtualFile file) {
        this.files.put(file.getName(), file);
    }

    @Override
    public void putFile(String path, byte[] data, long lastModified) {
        InMemoryFile file = new InMemoryFile(data, path, MimeMappings.getMimeType(path), lastModified);
        this.files.put(file.getName(), file);
    }

    @Override
    public long getLastModified() {
        return 0L;
    }
}

