/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.css.parser;

import org.apache.flex.forks.batik.css.parser.CSSSACMediaExpression;

public class CSSSACMediaQuery {
    protected boolean not;
    protected String mediaType;
    protected int numExpressions;
    protected CSSSACMediaExpression[] expressions = new CSSSACMediaExpression[1];

    CSSSACMediaQuery(boolean not, String mediaType) {
        this.not = not;
        this.mediaType = mediaType;
    }

    public boolean isNot() {
        return this.not;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int getNumExpressions() {
        return this.numExpressions;
    }

    public void appendExpression(CSSSACMediaExpression expr) {
        if (expr == null) {
            return;
        }
        if (this.numExpressions == this.expressions.length) {
            CSSSACMediaExpression[] tmp = this.expressions;
            this.expressions = new CSSSACMediaExpression[Math.max(this.expressions.length * 3 / 2, this.expressions.length + 1)];
            for (int i = 0; i < tmp.length; ++i) {
                this.expressions[i] = tmp[i];
            }
        }
        this.expressions[this.numExpressions++] = expr;
    }

    public CSSSACMediaExpression getExpression(int index) {
        if (index < 0 || index >= this.numExpressions) {
            return null;
        }
        return this.expressions[index];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.mediaType != null) {
            if (this.not) {
                buf.append("not ");
            }
            buf.append(this.mediaType);
            for (int i = 0; i < this.numExpressions; ++i) {
                buf.append(" and ");
                this.expressions[i].appendToStringBuffer(buf);
            }
        } else if (this.numExpressions > 0) {
            for (int i = 0; i < this.numExpressions - 1; ++i) {
                this.expressions[i].appendToStringBuffer(buf);
                buf.append(" and ");
            }
            this.expressions[this.numExpressions - 1].appendToStringBuffer(buf);
        }
        return buf.toString();
    }
}

