/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http2.BufferingFlowControlStrategy;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.RateControl;
import org.eclipse.jetty.http2.SessionContainer;
import org.eclipse.jetty.http2.WindowRateControl;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerSession;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;

@ManagedObject
public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private final SessionContainer sessionContainer = new HTTP2SessionContainer();
    private final HttpConfiguration httpConfiguration;
    private int maxDecoderTableCapacity = 4096;
    private int maxEncoderTableCapacity = 4096;
    private int initialSessionRecvWindow = 0x100000;
    private int initialStreamRecvWindow = 524288;
    private int maxConcurrentStreams = 128;
    private int maxHeaderBlockFragment = 0;
    private int maxFrameSize = 16384;
    private int maxSettingsKeys = 64;
    private boolean connectProtocolEnabled = true;
    private RateControl.Factory rateControlFactory = new WindowRateControl.Factory(128);
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private long streamIdleTimeout;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;

    private static boolean isProtocolSupported(String protocol) {
        return switch (protocol) {
            case "h2", "h2c" -> true;
            default -> false;
        };
    }

    public AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2");
    }

    protected AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(protocols);
        for (String p : protocols) {
            if (AbstractHTTP2ServerConnectionFactory.isProtocolSupported(p)) continue;
            throw new IllegalArgumentException("Unsupported HTTP2 Protocol variant: " + p);
        }
        this.installBean(this.sessionContainer);
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.installBean(httpConfiguration);
        this.setInputBufferSize(16393);
        this.setUseInputDirectByteBuffers(httpConfiguration.isUseInputDirectByteBuffers());
        this.setUseOutputDirectByteBuffers(httpConfiguration.isUseOutputDirectByteBuffers());
    }

    @ManagedAttribute(value="The HPACK encoder dynamic table maximum capacity")
    public int getMaxEncoderTableCapacity() {
        return this.maxEncoderTableCapacity;
    }

    public void setMaxEncoderTableCapacity(int maxEncoderTableCapacity) {
        this.maxEncoderTableCapacity = maxEncoderTableCapacity;
    }

    @ManagedAttribute(value="The HPACK decoder dynamic table maximum capacity")
    public int getMaxDecoderTableCapacity() {
        return this.maxDecoderTableCapacity;
    }

    public void setMaxDecoderTableCapacity(int maxDecoderTableCapacity) {
        this.maxDecoderTableCapacity = maxDecoderTableCapacity;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @ManagedAttribute(value="The max number of concurrent streams per session")
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @ManagedAttribute(value="The max header block fragment")
    public int getMaxHeaderBlockFragment() {
        return this.maxHeaderBlockFragment;
    }

    public void setMaxHeaderBlockFragment(int maxHeaderBlockFragment) {
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @ManagedAttribute(value="The max frame size in bytes")
    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @ManagedAttribute(value="The max number of keys in all SETTINGS frames")
    public int getMaxSettingsKeys() {
        return this.maxSettingsKeys;
    }

    public void setMaxSettingsKeys(int maxSettingsKeys) {
        this.maxSettingsKeys = maxSettingsKeys;
    }

    @ManagedAttribute(value="Whether CONNECT requests supports a protocol")
    public boolean isConnectProtocolEnabled() {
        return this.connectProtocolEnabled;
    }

    public void setConnectProtocolEnabled(boolean connectProtocolEnabled) {
        this.connectProtocolEnabled = connectProtocolEnabled;
    }

    public RateControl.Factory getRateControlFactory() {
        return this.rateControlFactory;
    }

    public void setRateControlFactory(RateControl.Factory rateControlFactory) {
        this.rateControlFactory = Objects.requireNonNull(rateControlFactory);
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for reading")
    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for writing")
    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    protected Map<Integer, Integer> newSettings() {
        int maxHeadersSize;
        int maxFrameSize;
        HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
        int maxTableSize = this.getMaxDecoderTableCapacity();
        if (maxTableSize != 4096) {
            settings.put(1, maxTableSize);
        }
        settings.put(3, this.getMaxConcurrentStreams());
        int initialStreamRecvWindow = this.getInitialStreamRecvWindow();
        if (initialStreamRecvWindow != 65535) {
            settings.put(4, initialStreamRecvWindow);
        }
        if ((maxFrameSize = this.getMaxFrameSize()) > 16384) {
            settings.put(5, maxFrameSize);
        }
        if ((maxHeadersSize = this.getHttpConfiguration().getRequestHeaderSize()) > 0) {
            settings.put(6, maxHeadersSize);
        }
        settings.put(8, this.isConnectProtocolEnabled() ? 1 : 0);
        return settings;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.isUseOutputDirectByteBuffers(), this.getMaxHeaderBlockFragment());
        int maxResponseHeaderSize = this.getHttpConfiguration().getMaxResponseHeaderSize();
        if (maxResponseHeaderSize < 0) {
            maxResponseHeaderSize = this.getHttpConfiguration().getResponseHeaderSize();
        }
        generator.getHpackEncoder().setMaxHeaderListSize(maxResponseHeaderSize);
        FlowControlStrategy flowControl = this.getFlowControlStrategyFactory().newFlowControlStrategy();
        ServerParser parser = this.newServerParser(connector, this.getRateControlFactory().newRateControl(endPoint));
        parser.setMaxSettingsKeys(this.getMaxSettingsKeys());
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, parser, generator, listener, flowControl);
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        session.setMaxEncoderTableCapacity(this.getMaxEncoderTableCapacity());
        long streamIdleTimeout = this.getStreamIdleTimeout();
        if (streamIdleTimeout == 0L) {
            streamIdleTimeout = endPoint.getIdleTimeout();
        }
        session.setStreamIdleTimeout(streamIdleTimeout);
        session.setInitialSessionRecvWindow(this.getInitialSessionRecvWindow());
        session.setWriteThreshold(this.getHttpConfiguration().getOutputBufferSize());
        session.setConnectProtocolEnabled(this.isConnectProtocolEnabled());
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector, endPoint, this.httpConfiguration, session, this.getInputBufferSize(), listener);
        connection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.isUseOutputDirectByteBuffers());
        connection.addEventListener(this.sessionContainer);
        this.getEventListeners().forEach(session::addEventListener);
        parser.init(connection);
        return this.configure(connection, connector, endPoint);
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    private ServerParser newServerParser(Connector connector, RateControl rateControl) {
        return new ServerParser(connector.getByteBufferPool(), this.getHttpConfiguration().getRequestHeaderSize(), rateControl);
    }

    @Deprecated(since="12.0.21", forRemoval=true)
    public static class HTTP2SessionContainer
    extends SessionContainer {
    }
}

