/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import jakarta.servlet.DispatcherType;
import org.apache.felix.http.base.internal.HttpConfig;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.ErrorPageRegistry;
import org.apache.felix.http.base.internal.registry.EventListenerRegistry;
import org.apache.felix.http.base.internal.registry.FilterRegistry;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.ServletRegistry;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.FailedDTOHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.servlet.runtime.dto.ServletContextDTO;

public final class PerContextHandlerRegistry
implements Comparable<PerContextHandlerRegistry> {
    private final long serviceId;
    private final int ranking;
    private final String path;
    private final String prefix;
    private final ServletRegistry servletRegistry = new ServletRegistry();
    private final FilterRegistry filterRegistry = new FilterRegistry();
    private final ErrorPageRegistry errorPageRegistry = new ErrorPageRegistry();
    private final EventListenerRegistry eventListenerRegistry = new EventListenerRegistry();
    private final HttpConfig config;

    public PerContextHandlerRegistry(@NotNull HttpConfig config) {
        this.config = config;
        this.serviceId = -1L;
        this.ranking = Integer.MAX_VALUE;
        this.path = "/";
        this.prefix = null;
    }

    public PerContextHandlerRegistry(@NotNull ServletContextHelperInfo info, @NotNull HttpConfig config) {
        this.config = config;
        this.serviceId = info.getServiceId();
        this.ranking = info.getRanking();
        this.path = info.getPath();
        this.prefix = this.path.equals("/") ? null : this.path + "/";
    }

    public long getContextServiceId() {
        return this.serviceId;
    }

    public HttpConfig getConfig() {
        return this.config;
    }

    public void removeAll() {
        this.errorPageRegistry.cleanup();
        this.eventListenerRegistry.cleanup();
        this.filterRegistry.cleanup();
        this.servletRegistry.cleanup();
    }

    @Override
    public int compareTo(@NotNull PerContextHandlerRegistry other) {
        int result = Integer.valueOf(other.path.length()).compareTo(this.path.length());
        if (result == 0) {
            if (this.ranking == other.ranking) {
                int reverseOrder = this.serviceId <= 0L && other.serviceId <= 0L ? -1 : 1;
                return reverseOrder * Long.valueOf(this.serviceId).compareTo(other.serviceId);
            }
            return Integer.valueOf(other.ranking).compareTo(this.ranking);
        }
        return result;
    }

    public String isMatching(@NotNull String requestURI) {
        if (requestURI.equals(this.path)) {
            return "";
        }
        if (this.prefix == null) {
            return requestURI;
        }
        if (requestURI.startsWith(this.prefix)) {
            return requestURI.substring(this.prefix.length() - 1);
        }
        return null;
    }

    public PathResolution resolve(@NotNull String relativeRequestURI) {
        return this.servletRegistry.resolve(relativeRequestURI);
    }

    public ServletHandler resolveServletByName(String name) {
        return this.servletRegistry.resolveByName(name);
    }

    @NotNull
    public FilterHandler[] getFilterHandlers(@Nullable ServletHandler servletHandler, @NotNull DispatcherType dispatcherType, @NotNull String requestURI) {
        return this.filterRegistry.getFilterHandlers(servletHandler, dispatcherType, requestURI);
    }

    @Nullable
    public ServletHandler getErrorHandler(int code, @Nullable Throwable exception) {
        return this.errorPageRegistry.get(exception, code);
    }

    public EventListenerRegistry getEventListenerRegistry() {
        return this.eventListenerRegistry;
    }

    public void getRuntime(ServletContextDTO dto, FailedDTOHolder failedDTOHolder) {
        this.filterRegistry.getRuntimeInfo(dto, failedDTOHolder.failedFilterDTOs);
        this.errorPageRegistry.getRuntimeInfo(dto, failedDTOHolder.failedErrorPageDTOs);
        this.servletRegistry.getRuntimeInfo(dto, failedDTOHolder.failedServletDTOs, failedDTOHolder.failedResourceDTOs);
        this.eventListenerRegistry.getRuntimeInfo(dto, failedDTOHolder.failedListenerDTOs);
    }

    public void registerServlet(@NotNull ServletHandler handler) {
        this.servletRegistry.addServlet(handler);
        this.errorPageRegistry.addServlet(handler);
    }

    public void unregisterServlet(@NotNull ServletInfo servletInfo, boolean destroy) {
        this.servletRegistry.removeServlet(servletInfo, destroy);
        this.errorPageRegistry.removeServlet(servletInfo, destroy);
    }

    public void registerFilter(@NotNull FilterHandler handler) {
        this.filterRegistry.addFilter(handler);
    }

    public void unregisterFilter(@NotNull FilterInfo info, boolean destroy) {
        this.filterRegistry.removeFilter(info, destroy);
    }

    public void registerListeners(@NotNull ListenerHandler listenerHandler) {
        this.eventListenerRegistry.addListeners(listenerHandler);
    }

    public void unregisterListeners(@NotNull ListenerInfo info) {
        this.eventListenerRegistry.removeListeners(info);
    }
}

