/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling.cron.embedded;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.EmbeddedCronParser;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.EmbeddedCronScheduler;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.EmbeddedCronSchedulerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncEmbeddedCronJob
extends AsyncJob {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncEmbeddedCronJob.class);
    private final String id;
    private final String cronExpression;
    private final EmbeddedCronParser cronParser;
    private final EmbeddedCronScheduler scheduler;
    private volatile boolean executing = false;
    private volatile long lastExecutingTime = 0L;
    private volatile long nextExecutingTime = 0L;

    public AsyncEmbeddedCronJob(Runnable runnable, EmbeddedCronSchedulerProvider embeddedCronSchedulerProvider, String id, String cronExpression) {
        super(runnable);
        this.id = id;
        this.scheduler = embeddedCronSchedulerProvider.getScheduler();
        this.cronExpression = cronExpression;
        this.cronParser = new EmbeddedCronParser(cronExpression);
        this.nextExecutingTime = this.cronParser.next(System.currentTimeMillis());
    }

    @Override
    public boolean schedule() {
        try {
            this.scheduler.schedule(this);
            LOG.info("Scheduled job {} with trigger {}", (Object)this.id, (Object)this.cronExpression);
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not schedule job for {}", (Object)this.runnable, (Object)e);
            return false;
        }
    }

    @Override
    public boolean unschedule() {
        LOG.debug("Unscheduling job {}", (Object)this.id);
        try {
            this.scheduler.remove(this);
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not unschedule job for {}", (Object)this.id, (Object)e);
            return false;
        }
    }

    public String toString() {
        return "[Async embedded cron job for " + this.runnable + "]";
    }

    public String getId() {
        return this.id;
    }

    public long getLastExecutingTime() {
        return this.lastExecutingTime;
    }

    public long getNextExecutingTime() {
        return this.nextExecutingTime;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void checkAndExecute(ExecutorService tasksExecutor) {
        long currentTime = System.currentTimeMillis();
        if (this.nextExecutingTime >= currentTime) {
            return;
        }
        if (this.executing) {
            this.nextExecutingTime = this.cronParser.next(System.currentTimeMillis());
            LOG.trace("Cron task {} would be fired but is still executing, skipping this execution, next execution: {}", (Object)this.id, (Object)this.nextExecutingTime);
            return;
        }
        try {
            this.lastExecutingTime = currentTime;
            this.executing = true;
            tasksExecutor.execute(() -> {
                try {
                    this.runnable.run();
                }
                catch (Exception e) {
                    LOG.error("Exception while executing cron task {}", (Object)this.id, (Object)e);
                }
                finally {
                    this.nextExecutingTime = this.cronParser.next(System.currentTimeMillis());
                    this.executing = false;
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.executing = false;
            LOG.error("Failed to start cron task: {}", (Object)this.id, (Object)e);
        }
    }
}

