/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;

class URLHandlersBundleStreamHandler
extends URLStreamHandler {
    private final Felix m_framework;
    private final SecureAction m_action;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersBundleURLConnection;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;

    public URLHandlersBundleStreamHandler(Felix framework) {
        this.m_framework = framework;
        this.m_action = null;
    }

    public URLHandlersBundleStreamHandler(SecureAction action) {
        this.m_framework = null;
        this.m_action = action;
    }

    protected synchronized URLConnection openConnection(URL url) throws IOException {
        if (!"felix".equals(url.getAuthority())) {
            this.checkPermission(url);
        }
        if (this.m_framework != null) {
            return new URLHandlersBundleURLConnection(url, this.m_framework);
        }
        Object framework = URLHandlers.getFrameworkFromContext();
        if (framework != null) {
            if (framework instanceof Felix) {
                return new URLHandlersBundleURLConnection(url, (Felix)framework);
            }
            try {
                Class<?> targetClass = framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$URLHandlersBundleURLConnection == null ? (class$org$apache$felix$framework$URLHandlersBundleURLConnection = URLHandlersBundleStreamHandler.class$("org.apache.felix.framework.URLHandlersBundleURLConnection")) : class$org$apache$felix$framework$URLHandlersBundleURLConnection).getName());
                Constructor constructor = this.m_action.getConstructor(targetClass, new Class[]{class$java$net$URL == null ? (class$java$net$URL = URLHandlersBundleStreamHandler.class$("java.net.URL")) : class$java$net$URL, framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = URLHandlersBundleStreamHandler.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getName())});
                this.m_action.setAccesssible(constructor);
                return (URLConnection)this.m_action.invoke(constructor, new Object[]{url, framework});
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }
        throw new IOException("No framework context found");
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        super.parseURL(u, spec, start, limit);
        if (this.checkPermission(u)) {
            super.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), "felix", u.getUserInfo(), u.getPath(), u.getQuery(), u.getRef());
        }
    }

    protected String toExternalForm(URL u) {
        StringBuffer result = new StringBuffer();
        result.append(u.getProtocol());
        result.append("://");
        result.append(u.getHost());
        result.append(':');
        result.append(u.getPort());
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    private boolean checkPermission(URL u) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Object framework = this.m_framework;
            if (framework == null && !((framework = URLHandlers.getFrameworkFromContext()) instanceof Felix)) {
                return false;
            }
            Object felix = framework;
            long bundleId = Util.getBundleIdFromModuleId(u.getHost());
            Bundle bundle = ((Felix)felix).getBundle(bundleId);
            if (bundle != null) {
                sm.checkPermission(new AdminPermission(bundle, "resource"));
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

