/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.prefs.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.prefs.BackingStoreManager;
import org.apache.felix.prefs.PreferencesDescription;
import org.apache.felix.prefs.PreferencesImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class PreferencesServiceImpl
implements PreferencesService {
    protected PreferencesImpl systemTree;
    protected final Map trees = new HashMap();
    protected final Long bundleId;
    protected final BackingStoreManager storeManager;

    public PreferencesServiceImpl(Long id, BackingStoreManager storeManager) {
        this.bundleId = id;
        this.storeManager = storeManager;
        try {
            PreferencesImpl[] prefs = null;
            prefs = this.storeManager.getStore().loadAll(storeManager, this.bundleId);
            for (int i = 0; i < prefs.length; ++i) {
                if (prefs[i].getDescription().getIdentifier() == null) {
                    this.systemTree = prefs[i];
                    continue;
                }
                this.trees.put(prefs[i].getDescription().getIdentifier(), prefs[i]);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public synchronized Preferences getSystemPreferences() {
        if (this.systemTree == null) {
            this.systemTree = new PreferencesImpl(new PreferencesDescription(this.bundleId, null), this.storeManager);
        }
        try {
            this.systemTree.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return this.systemTree;
    }

    public synchronized Preferences getUserPreferences(String name) {
        PreferencesImpl result = (PreferencesImpl)this.trees.get(name);
        if (result == null || !result.isValid()) {
            result = new PreferencesImpl(new PreferencesDescription(this.bundleId, name), this.storeManager);
            this.trees.put(name, result);
        }
        try {
            result.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return result;
    }

    public synchronized String[] getUsers() {
        Set userKeys = this.trees.keySet();
        return userKeys.toArray(new String[userKeys.size()]);
    }

    protected List getAllPreferences() {
        ArrayList<PreferencesImpl> list = new ArrayList<PreferencesImpl>();
        if (this.systemTree != null) {
            list.add(this.systemTree);
        }
        list.addAll(this.trees.values());
        return list;
    }
}

