/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.SystemUtils;
import org.apache.eventmesh.openconnect.ConnectorWorker;
import org.apache.eventmesh.openconnect.api.config.SinkConfig;
import org.apache.eventmesh.openconnect.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkWorker
implements ConnectorWorker {
    private static final Logger log = LoggerFactory.getLogger(SinkWorker.class);
    private final Sink sink;
    private final SinkConfig config;
    private final EventMeshTCPClient<CloudEvent> eventMeshTCPClient;

    public SinkWorker(Sink sink, SinkConfig config) throws Exception {
        this.sink = sink;
        this.config = config;
        this.eventMeshTCPClient = this.buildEventMeshSubClient(config);
        this.eventMeshTCPClient.init();
    }

    private EventMeshTCPClient<CloudEvent> buildEventMeshSubClient(SinkConfig config) {
        String meshAddress = config.getPubSubConfig().getMeshAddress();
        String meshIp = meshAddress.split(":")[0];
        int meshPort = Integer.parseInt(meshAddress.split(":")[1]);
        UserAgent agent = UserAgent.builder().env(config.getPubSubConfig().getEnv()).host("localhost").password(config.getPubSubConfig().getPassWord()).username(config.getPubSubConfig().getUserName()).group(config.getPubSubConfig().getGroup()).path("/").port(8362).subsystem(config.getPubSubConfig().getAppId()).pid(Integer.parseInt(SystemUtils.getProcessId())).version("2.0").idc(config.getPubSubConfig().getIdc()).build();
        UserAgent userAgent = MessageUtils.generateSubClient((UserAgent)agent);
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(meshIp).port(meshPort).userAgent(userAgent).build();
        return EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, CloudEvent.class);
    }

    @Override
    public void start() {
        log.info("sink worker starting {}", (Object)this.sink.name());
        log.info("event mesh address is {}", (Object)this.config.getPubSubConfig().getMeshAddress());
        try {
            this.sink.start();
        }
        catch (Exception e) {
            log.error("sink worker[{}] start fail", (Object)this.sink.name(), (Object)e);
            return;
        }
        this.eventMeshTCPClient.subscribe(this.config.getPubSubConfig().getSubject(), SubscriptionMode.CLUSTERING, SubscriptionType.ASYNC);
        this.eventMeshTCPClient.registerSubBusiHandler((ReceiveMsgHook)new EventHandler(this.sink));
        this.eventMeshTCPClient.listen();
    }

    @Override
    public void stop() {
        log.info("sink worker stopping");
        try {
            this.eventMeshTCPClient.unsubscribe();
            this.eventMeshTCPClient.close();
        }
        catch (Exception e) {
            log.error("event mesh client close", (Throwable)e);
        }
        try {
            this.sink.stop();
        }
        catch (Exception e) {
            log.error("sink destroy error", (Throwable)e);
        }
        log.info("source worker stopped");
    }

    static class EventHandler
    implements ReceiveMsgHook<CloudEvent> {
        private final Sink sink;

        public EventHandler(Sink sink) {
            this.sink = sink;
        }

        public Optional<CloudEvent> handle(CloudEvent event) {
            byte[] body = Objects.requireNonNull(event.getData()).toBytes();
            log.info("handle receive events {}", (Object)new String(event.getData().toBytes()));
            ConnectRecord connectRecord = new ConnectRecord(null, null, System.currentTimeMillis(), body);
            for (String extensionName : event.getExtensionNames()) {
                connectRecord.addExtension(extensionName, Objects.requireNonNull(event.getExtension(extensionName)).toString());
            }
            connectRecord.addExtension("id", event.getId());
            connectRecord.addExtension("topic", event.getSubject());
            connectRecord.addExtension("source", event.getSource().toString());
            connectRecord.addExtension("type", event.getType());
            ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>();
            connectRecords.add(connectRecord);
            this.sink.put(connectRecords);
            return Optional.empty();
        }
    }
}

