/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect;

import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.openconnect.ConnectorWorker;
import org.apache.eventmesh.openconnect.SinkWorker;
import org.apache.eventmesh.openconnect.SourceWorker;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.config.SinkConfig;
import org.apache.eventmesh.openconnect.api.config.SourceConfig;
import org.apache.eventmesh.openconnect.api.connector.Connector;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    public static final Map<String, Connector> CONNECTOR_MAP = new HashMap<String, Connector>();

    public void run(Class<? extends Connector> clazz) throws Exception {
        ConnectorWorker worker;
        Config config;
        Connector connector;
        try {
            connector = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("new connector error", (Throwable)e);
            return;
        }
        try {
            config = ConfigUtil.parse(connector.configClass());
        }
        catch (Exception e) {
            log.error("parse config error", (Throwable)e);
            return;
        }
        try {
            connector.init(config);
            CONNECTOR_MAP.putIfAbsent(connector.name(), connector);
        }
        catch (Exception e) {
            log.error("connector {} initialize error", (Object)connector.name(), (Object)e);
            return;
        }
        if (Application.isSink(clazz)) {
            worker = new SinkWorker((Sink)connector, (SinkConfig)config);
        } else if (Application.isSource(clazz)) {
            worker = new SourceWorker((Source)connector, (SourceConfig)config);
        } else {
            log.error("class {} is not sink and source", clazz);
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            worker.stop();
            log.info("connector {} stopped", (Object)connector.name());
        }));
        worker.start();
        log.info("connector {} started", (Object)connector.name());
    }

    public static boolean isAssignableFrom(Class<?> c, Class<?> cls) {
        Class<?>[] clazzArr;
        for (Class<?> clazz : clazzArr = c.getInterfaces()) {
            if (!clazz.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSink(Class<?> c) {
        while (c != null && c != Object.class) {
            if (Application.isAssignableFrom(c, Sink.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static boolean isSource(Class<?> c) {
        while (c != null && c != Object.class) {
            if (Application.isAssignableFrom(c, Source.class)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }
}

