/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.bootstrap.config.ProfileLogConfigResolver;
import com.navercorp.pinpoint.bootstrap.config.PropertyLoader;
import com.navercorp.pinpoint.common.util.PropertyUtils;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

class SimplePropertyLoader
implements PropertyLoader {
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final SimpleProperty systemProperty;
    private final Path agentRootPath;
    private final Path profilesPath;

    public SimplePropertyLoader(SimpleProperty systemProperty, Path agentRootPath, Path profilesPath) {
        this.systemProperty = Objects.requireNonNull(systemProperty, "systemProperty");
        this.agentRootPath = Objects.requireNonNull(agentRootPath, "agentRootPath");
        this.profilesPath = profilesPath;
    }

    @Override
    public Properties load() {
        Path defaultConfigPath = this.agentRootPath.resolve("pinpoint-root.config");
        Properties defaultProperties = new Properties();
        String externalConfig = this.systemProperty.getProperty("pinpoint.config");
        if (externalConfig != null) {
            this.logger.info(String.format("load external config:%s", externalConfig));
            this.loadFileProperties(defaultProperties, Paths.get(externalConfig, new String[0]));
        } else {
            this.logger.info(String.format("load default config:%s", defaultConfigPath));
            this.loadFileProperties(defaultProperties, defaultConfigPath);
        }
        this.loadSystemProperties(defaultProperties);
        this.saveLogConfigLocation(defaultProperties);
        return defaultProperties;
    }

    private void saveLogConfigLocation(Properties properties) {
        String activeProfile = this.systemProperty.getProperty("pinpoint.profiler.profiles.active", "release");
        ProfileLogConfigResolver logConfigResolver = new ProfileLogConfigResolver(this.profilesPath, activeProfile);
        Path log4jLocation = logConfigResolver.getLogPath();
        properties.put("pinpoint.profiler.log.config.location", log4jLocation.toString());
        this.logger.info(String.format("logConfig path:%s", log4jLocation));
    }

    private void loadFileProperties(Properties properties, Path filePath) {
        try {
            PropertyUtils.loadProperty((Properties)properties, (Path)filePath);
        }
        catch (IOException e) {
            this.logger.info(String.format("%s load fail Caused by:%s", filePath, e.getMessage()));
            throw new IllegalStateException(String.format("%s load fail Caused by:%s", filePath, e.getMessage()));
        }
    }

    private void loadSystemProperties(Properties dstProperties) {
        Set stringPropertyNames = this.systemProperty.stringPropertyNames();
        for (String propertyName : stringPropertyNames) {
            boolean isPinpointProperty = propertyName.startsWith("bytecode.") || propertyName.startsWith("profiler.") || propertyName.startsWith("pinpoint.");
            if (!isPinpointProperty) continue;
            String val = this.systemProperty.getProperty(propertyName);
            dstProperties.setProperty(propertyName, val);
        }
    }
}

