/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.io.File;
import java.util.Objects;
import java.util.Properties;

public class ContainerResolver {
    public static final String CONTAINER_PROPERTY_KEY = "pinpoint.container";
    public static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private final BootLogger logger = BootLogger.getLogger(this.getClass());
    private final Properties properties;

    public ContainerResolver() {
        this(System.getProperties());
    }

    public ContainerResolver(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public boolean isContainer() {
        if (this.properties.containsKey(CONTAINER_PROPERTY_KEY)) {
            return this.readPropertyBool(CONTAINER_PROPERTY_KEY);
        }
        return this.isDockerEnv();
    }

    private boolean readPropertyBool(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            this.logger.info("-D" + key + " found.");
            return true;
        }
        boolean boolValue = Boolean.parseBoolean(value);
        this.logger.info("-D" + key + " found : " + value + ", resolved to " + boolValue);
        return boolValue;
    }

    private boolean isDockerEnv() {
        File file = new File("/.dockerenv");
        return file.exists() || System.getenv(KUBERNETES_SERVICE_HOST) != null;
    }
}

