/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.test.util.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.rocketmq.test.util.parallel.ParallelTask;

public class ParallelTaskExecutor {
    public List<ParallelTask> tasks = new ArrayList<ParallelTask>();
    public ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    public CountDownLatch latch = null;

    public void pushTask(ParallelTask task) {
        this.tasks.add(task);
    }

    public void startBlock() {
        this.init();
        this.startTask();
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void startNoBlock() {
        for (ParallelTask task : this.tasks) {
            this.cachedThreadPool.execute(task);
        }
    }

    private void init() {
        this.latch = new CountDownLatch(this.tasks.size());
        for (ParallelTask task : this.tasks) {
            task.setLatch(this.latch);
        }
    }

    private void startTask() {
        for (ParallelTask task : this.tasks) {
            task.start();
        }
    }
}

