/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Single;
import org.reactivestreams.Publisher;
import org.redisson.RedissonObject;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLockRx;
import org.redisson.api.RPermitExpirableSemaphoreRx;
import org.redisson.api.RReadWriteLockRx;
import org.redisson.api.RSemaphoreRx;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonRxClient;
import org.redisson.client.RedisClient;
import org.redisson.rx.PublisherAdder;
import org.redisson.rx.SetRxIterator;

public class RedissonSetCacheRx<V> {
    private final RSetCache<V> instance;
    private final RedissonRxClient redisson;

    public RedissonSetCacheRx(RSetCache<V> instance, RedissonRxClient redisson) {
        this.instance = instance;
        this.redisson = redisson;
    }

    public Publisher<V> iterator() {
        return new SetRxIterator<V>(){

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((ScanIterator)((Object)RedissonSetCacheRx.this.instance)).scanIteratorAsync(((RedissonObject)((Object)RedissonSetCacheRx.this.instance)).getRawName(), client, nextIterPos, null, 10);
            }
        }.create();
    }

    public Single<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonSetCacheRx.this.instance.addAsync(o);
            }
        }.addAll(c);
    }

    public RPermitExpirableSemaphoreRx getPermitExpirableSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreRx getSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockRx getFairLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockRx getReadWriteLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockRx getLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "lock");
        return this.redisson.getLock(name);
    }
}

