/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.RedissonKeys;
import org.redisson.client.RedisClient;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.rx.CommandRxExecutor;

public class RedissonKeysRx {
    private final CommandRxExecutor commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysRx(CommandRxExecutor commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Flowable<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    public Flowable<String> getKeys(int count) {
        return this.getKeysByPattern(null, count);
    }

    public Flowable<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Flowable<String> getKeysByPattern(String pattern, int count) {
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern, count));
        }
        return Flowable.merge(publishers);
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){
            private RedisClient client;
            private List<String> firstValues;
            private long nextIterPos;
            private long currentIndex;

            public void accept(long value) {
                this.currentIndex = value;
                this.nextValues();
            }

            protected void nextValues() {
                RedissonKeysRx.this.instance.scanIteratorAsync(this.client, entry, this.nextIterPos, pattern, count).whenComplete((res, e) -> {
                    if (e != null) {
                        p.onError(e);
                        return;
                    }
                    this.client = res.getRedisClient();
                    long prevIterPos = this.nextIterPos;
                    if (this.nextIterPos == 0L && this.firstValues == null) {
                        this.firstValues = (List)res.getValues();
                    } else if (res.getValues().equals(this.firstValues)) {
                        p.onComplete();
                        this.currentIndex = 0L;
                        return;
                    }
                    this.nextIterPos = res.getPos();
                    if (prevIterPos == this.nextIterPos) {
                        this.nextIterPos = -1L;
                    }
                    for (Object val : res.getValues()) {
                        p.onNext((Object)((String)val));
                        --this.currentIndex;
                        if (this.currentIndex != 0L) continue;
                        p.onComplete();
                        return;
                    }
                    if (this.nextIterPos == -1L) {
                        p.onComplete();
                        this.currentIndex = 0L;
                    }
                    if (this.currentIndex == 0L) {
                        return;
                    }
                    this.nextValues();
                });
            }
        });
    }
}

