/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.concurrent.CompletableFuture;
import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.pubsub.PublishSubscribe;
import org.redisson.pubsub.PublishSubscribeService;

public class CountDownLatchPubSub
extends PublishSubscribe<RedissonCountDownLatchEntry> {
    public static final Long ZERO_COUNT_MESSAGE = 0L;
    public static final Long NEW_COUNT_MESSAGE = 1L;

    public CountDownLatchPubSub(PublishSubscribeService service) {
        super(service);
    }

    @Override
    protected RedissonCountDownLatchEntry createEntry(CompletableFuture<RedissonCountDownLatchEntry> newPromise) {
        return new RedissonCountDownLatchEntry(newPromise);
    }

    @Override
    protected void onMessage(RedissonCountDownLatchEntry value, Long message) {
        if (message.equals(ZERO_COUNT_MESSAGE)) {
            Runnable runnableToExecute = value.getListeners().poll();
            if (runnableToExecute != null) {
                runnableToExecute.run();
            }
            value.getLatch().open();
        }
        if (message.equals(NEW_COUNT_MESSAGE)) {
            value.getLatch().close();
        }
    }
}

