/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.util.concurrent.Callable;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;
import org.redisson.api.mapreduce.RCollator;
import org.redisson.client.codec.Codec;
import org.redisson.misc.Injector;

public class CollatorTask<KOut, VOut, R>
implements Callable<R> {
    @RInject
    private RedissonClient redisson;
    private RCollator<KOut, VOut, R> collator;
    private String resultMapName;
    private Class<?> codecClass;
    private Codec codec;

    public CollatorTask() {
    }

    public CollatorTask(RedissonClient redisson, RCollator<KOut, VOut, R> collator, String resultMapName, Class<?> codecClass) {
        this.redisson = redisson;
        this.collator = collator;
        this.resultMapName = resultMapName;
        this.codecClass = codecClass;
    }

    @Override
    public R call() throws Exception {
        this.codec = (Codec)this.codecClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Injector.inject(this.collator, this.redisson);
        RMap resultMap = this.redisson.getMap(this.resultMapName, this.codec);
        R result = this.collator.collate(resultMap);
        resultMap.delete();
        return result;
    }
}

