/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.AsyncCountDownLatch;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedConnectionManager
extends MasterSlaveConnectionManager {
    private static final String ROLE_KEY = "role";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<InetSocketAddress> currentMaster = new AtomicReference();
    private ScheduledFuture<?> monitorFuture;

    public ReplicatedConnectionManager(ReplicatedServersConfig cfg, Config config, UUID id) {
        super(config, id);
        this.config = this.create(cfg);
        this.initTimer(this.config);
        for (String address : cfg.getNodeAddresses()) {
            RedisURI addr = new RedisURI(address);
            CompletionStage<RedisConnection> connectionFuture = this.connectToNode(cfg, addr, addr.getHost());
            RedisConnection connection = null;
            try {
                connection = connectionFuture.toCompletableFuture().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connection == null) continue;
            Role role = Role.valueOf(connection.sync(RedisCommands.INFO_REPLICATION, new Object[0]).get(ROLE_KEY));
            if (Role.master.equals((Object)role)) {
                this.currentMaster.set(connection.getRedisClient().getAddr());
                this.log.info("{} is the master", (Object)addr);
                this.config.setMasterAddress(addr.toString());
                continue;
            }
            this.log.info("{} is a slave", (Object)addr);
            this.config.addSlaveAddress(addr.toString());
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!");
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found! Please specify all nodes in replicated mode.");
        }
        this.initSingleEntry();
        this.scheduleMasterChangeCheck(cfg);
    }

    @Override
    protected void startDNSMonitoring(RedisClient masterHost) {
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((ReplicatedServersConfig)cfg).getDatabase());
        return res;
    }

    private void scheduleMasterChangeCheck(ReplicatedServersConfig cfg) {
        if (this.isShuttingDown()) {
            return;
        }
        this.monitorFuture = this.group.schedule(() -> {
            if (this.isShuttingDown()) {
                return;
            }
            Set<InetSocketAddress> slaveIPs = Collections.newSetFromMap(new ConcurrentHashMap());
            AsyncCountDownLatch latch = new AsyncCountDownLatch();
            latch.latch(() -> {
                this.checkFailedSlaves(slaveIPs);
                this.scheduleMasterChangeCheck(cfg);
            }, cfg.getNodeAddresses().size());
            for (String address : cfg.getNodeAddresses()) {
                RedisURI uri = new RedisURI(address);
                this.checkNode(latch, uri, cfg, slaveIPs);
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkFailedSlaves(Set<InetSocketAddress> slaveIPs) {
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        Set failedSlaves = entry.getAllEntries().stream().filter(e -> e.getNodeType() == NodeType.SLAVE && !slaveIPs.contains(e.getClient().getAddr())).map(e -> e.getClient()).collect(Collectors.toSet());
        for (RedisClient slave : failedSlaves) {
            if (!entry.slaveDown(slave.getAddr(), ClientConnectionsEntry.FreezeReason.MANAGER)) continue;
            this.log.info("slave: {} is down", (Object)slave);
            this.disconnectNode(new RedisURI(slave.getConfig().getAddress().getScheme(), slave.getAddr().getAddress().getHostAddress(), slave.getAddr().getPort()));
        }
    }

    private void checkNode(AsyncCountDownLatch latch, RedisURI uri, ReplicatedServersConfig cfg, Set<InetSocketAddress> slaveIPs) {
        CompletionStage<RedisConnection> connectionFuture = this.connectToNode(cfg, uri, uri.getHost());
        connectionFuture.whenComplete((connection, exc) -> {
            if (exc != null) {
                this.log.error(exc.getMessage(), exc);
                latch.countDown();
                return;
            }
            if (this.isShuttingDown()) {
                return;
            }
            RFuture result = connection.async(RedisCommands.INFO_REPLICATION, new Object[0]);
            result.whenComplete((r, ex) -> {
                if (ex != null) {
                    this.log.error(ex.getMessage(), ex);
                    latch.countDown();
                    return;
                }
                InetSocketAddress addr = connection.getRedisClient().getAddr();
                Role role = Role.valueOf((String)r.get(ROLE_KEY));
                if (Role.master.equals((Object)role)) {
                    InetSocketAddress master = this.currentMaster.get();
                    if (master.equals(addr)) {
                        this.log.debug("Current master {} unchanged", (Object)master);
                    } else if (this.currentMaster.compareAndSet(master, addr)) {
                        CompletableFuture<RedisClient> changeFuture = this.changeMaster(this.singleSlotRange.getStartSlot(), uri);
                        changeFuture.exceptionally(e -> {
                            this.log.error("Unable to change master to " + addr, e);
                            this.currentMaster.compareAndSet(addr, master);
                            return null;
                        });
                    }
                    latch.countDown();
                } else if (!this.config.checkSkipSlavesInit()) {
                    CompletableFuture<Void> f = this.slaveUp(addr, uri);
                    slaveIPs.add(addr);
                    f.whenComplete((res, e) -> latch.countDown());
                }
            });
        });
    }

    private CompletableFuture<Void> slaveUp(InetSocketAddress address, RedisURI uri) {
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (!entry.hasSlave(address)) {
            CompletableFuture<Void> f = entry.addSlave(address, uri, uri.getHost());
            return f.whenComplete((r, e) -> {
                if (e != null) {
                    this.log.error("Unable to add slave", e);
                    return;
                }
                this.log.info("slave: {} added", (Object)address);
            });
        }
        if (entry.slaveUp(address, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            this.log.info("slave: {} is up", (Object)address);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.closeNodeConnections();
        super.shutdown();
    }

    private static enum Role {
        master,
        slave;

    }
}

