/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.coders.FSTStreamDecoder;
import org.nustaq.serialization.coders.FSTStreamEncoder;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FstCodec
extends BaseCodec {
    private final boolean useCache;
    private final FSTConfiguration config;
    private final byte[] emptyArray = new byte[0];
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ByteBufInputStream in = new ByteBufInputStream(buf);
            FSTObjectInput inputStream = FstCodec.this.config.getObjectInput((InputStream)in);
            try {
                Object object = inputStream.readObject();
                return object;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                if (!FstCodec.this.useCache) {
                    inputStream.resetForReuseUseArray(FstCodec.this.emptyArray);
                }
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            ByteBufOutputStream os = new ByteBufOutputStream(out);
            FSTObjectOutput oos = FstCodec.this.config.getObjectOutput((OutputStream)os);
            try {
                oos.writeObject(in);
                oos.flush();
                ByteBuf byteBuf = os.buffer();
                return byteBuf;
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
            catch (Exception e) {
                out.release();
                throw new IOException(e);
            }
            finally {
                if (!FstCodec.this.useCache) {
                    oos.resetForReUse(FstCodec.this.emptyArray);
                }
            }
        }
    };

    public FstCodec() {
        this(FSTConfiguration.createDefaultConfiguration());
    }

    public FstCodec(ClassLoader classLoader) {
        this(FstCodec.createConfig(classLoader));
    }

    public FstCodec(ClassLoader classLoader, FstCodec codec) {
        this(FstCodec.copy(classLoader, codec));
    }

    private static FSTConfiguration copy(ClassLoader classLoader, FstCodec codec) {
        FSTConfiguration def = codec.config.deriveConfiguration();
        def.setClassLoader(classLoader);
        def.setCoderSpecific(codec.config.getCoderSpecific());
        def.setCrossPlatform(codec.config.isCrossPlatform());
        def.setForceClzInit(codec.config.isForceClzInit());
        def.setForceSerializable(codec.config.isForceSerializable());
        def.setInstantiator(codec.config.getInstantiator(null));
        def.setJsonFieldNames(codec.config.getJsonFieldNames());
        def.setLastResortResolver(codec.config.getLastResortResolver());
        def.setName(codec.config.getName());
        def.setPreferSpeed(codec.config.isPreferSpeed());
        def.setStructMode(codec.config.isStructMode());
        def.setShareReferences(codec.config.isShareReferences());
        def.setStreamCoderFactory(codec.config.getStreamCoderFactory());
        def.setVerifier(codec.config.getVerifier());
        try {
            Field serializationInfoRegistryField = FSTConfiguration.class.getDeclaredField("serializationInfoRegistry");
            serializationInfoRegistryField.setAccessible(true);
            FSTClazzInfoRegistry registry = (FSTClazzInfoRegistry)serializationInfoRegistryField.get(codec.config);
            serializationInfoRegistryField.set(def, registry);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return def;
    }

    private static FSTConfiguration createConfig(ClassLoader classLoader) {
        FSTConfiguration def = FSTConfiguration.createDefaultConfiguration();
        def.setClassLoader(classLoader);
        return def;
    }

    public FstCodec(FSTConfiguration fstConfiguration) {
        this(fstConfiguration, true);
    }

    public FstCodec(FSTConfiguration fstConfiguration, boolean useCache) {
        this.config = fstConfiguration;
        FSTSerializerRegistry reg = this.config.getCLInfoRegistry().getSerializerRegistry();
        reg.putSerializer(Hashtable.class, (FSTObjectSerializer)new FSTMapSerializerV2(), true);
        reg.putSerializer(ConcurrentHashMap.class, (FSTObjectSerializer)new FSTMapSerializerV2(), true);
        this.config.setStreamCoderFactory((FSTConfiguration.StreamCoderFactory)new FSTDefaultStreamCoderFactory(this.config));
        this.useCache = useCache;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.config.getClassLoader() != null) {
            return this.config.getClassLoader();
        }
        return super.getClassLoader();
    }

    static class FSTMapSerializerV2
    extends FSTBasicObjectSerializer {
        FSTMapSerializerV2() {
        }

        public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
            Map col = (Map)toWrite;
            out.writeInt(col.size());
            FSTClazzInfo lastKClzI = null;
            FSTClazzInfo lastVClzI = null;
            Class<?> lastKClz = null;
            Class<?> lastVClz = null;
            for (Map.Entry next : col.entrySet()) {
                Object key = next.getKey();
                Object value = next.getValue();
                if (key != null && value != null) {
                    lastKClzI = out.writeObjectInternal(key, key.getClass() == lastKClz ? lastKClzI : null, null);
                    lastVClzI = out.writeObjectInternal(value, value.getClass() == lastVClz ? lastVClzI : null, null);
                    lastKClz = key.getClass();
                    lastVClz = value.getClass();
                    continue;
                }
                out.writeObjectInternal(key, null, null);
                out.writeObjectInternal(value, null, null);
            }
        }

        public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
            Object res = null;
            int len = in.readInt();
            res = objectClass == HashMap.class ? new HashMap(len) : (objectClass == Hashtable.class ? new Hashtable(len) : serializationInfo.newInstance(true));
            in.registerObject(res, streamPosition, serializationInfo, referencee);
            Map col = (Map)res;
            for (int i = 0; i < len; ++i) {
                Object key = in.readObjectInternal(null);
                Object val = in.readObjectInternal(null);
                col.put(key, val);
            }
            return res;
        }
    }

    static class FSTDefaultStreamCoderFactory
    implements FSTConfiguration.StreamCoderFactory {
        Field chBufField;
        Field ascStringCacheField;
        private FSTConfiguration fstConfiguration;
        static ThreadLocal input = new ThreadLocal();
        static ThreadLocal output = new ThreadLocal();

        FSTDefaultStreamCoderFactory(FSTConfiguration fstConfiguration) {
            try {
                this.chBufField = FSTStreamDecoder.class.getDeclaredField("chBufS");
                this.ascStringCacheField = FSTStreamDecoder.class.getDeclaredField("ascStringCache");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.ascStringCacheField.setAccessible(true);
            this.chBufField.setAccessible(true);
            this.fstConfiguration = fstConfiguration;
        }

        public FSTEncoder createStreamEncoder() {
            return new FSTStreamEncoder(this.fstConfiguration);
        }

        public FSTDecoder createStreamDecoder() {
            return new FSTStreamDecoder(this.fstConfiguration){

                public String readStringUTF() throws IOException {
                    try {
                        String res = super.readStringUTF();
                        chBufField.set((Object)this, null);
                        return res;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }

                public String readStringAsc() throws IOException {
                    try {
                        String res = super.readStringAsc();
                        ascStringCacheField.set((Object)this, null);
                        return res;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            };
        }

        public ThreadLocal getInput() {
            return input;
        }

        public ThreadLocal getOutput() {
            return output;
        }
    }
}

