/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.EmptyConvertor;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class RedisCommand<R> {
    private final String name;
    private final String subName;
    private final MultiDecoder<R> replayMultiDecoder;
    Convertor<R> convertor = new EmptyConvertor();

    public RedisCommand(RedisCommand<R> command, String name) {
        this.name = name;
        this.subName = command.subName;
        this.replayMultiDecoder = command.replayMultiDecoder;
        this.convertor = command.convertor;
    }

    public RedisCommand(RedisCommand<R> command, String name, Convertor<R> convertor) {
        this.name = name;
        this.subName = command.subName;
        this.replayMultiDecoder = command.replayMultiDecoder;
        this.convertor = convertor;
    }

    public RedisCommand(String name) {
        this(name, (String)null);
    }

    public RedisCommand(String name, String subName) {
        this(name, subName, (MultiDecoder)null);
    }

    public RedisCommand(String name, String subName, Convertor<R> convertor) {
        this(name, subName);
        this.convertor = convertor;
    }

    public RedisCommand(String name, Convertor<R> convertor) {
        this(name, null, (MultiDecoder)null);
        this.convertor = convertor;
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder) {
        this(name, null, replayMultiDecoder);
    }

    public RedisCommand(String name, MultiDecoder<R> replayMultiDecoder, Convertor<R> convertor) {
        this(name, replayMultiDecoder);
        this.convertor = convertor;
    }

    public RedisCommand(String name, String subName, MultiDecoder<R> replayMultiDecoder) {
        this.name = name;
        this.subName = subName;
        this.replayMultiDecoder = replayMultiDecoder != null ? replayMultiDecoder : (parts, state) -> parts;
    }

    public String getSubName() {
        return this.subName;
    }

    public String getName() {
        return this.name;
    }

    public MultiDecoder<R> getReplayMultiDecoder() {
        return this.replayMultiDecoder;
    }

    public Convertor<R> getConvertor() {
        return this.convertor;
    }

    public boolean isNoRetry() {
        return RedisCommands.NO_RETRY.contains(this.getName()) || RedisCommands.NO_RETRY_COMMANDS.contains(this);
    }

    public boolean isBlockingCommand() {
        return RedisCommands.BLOCKING_COMMAND_NAMES.contains(this.getName()) || RedisCommands.BLOCKING_COMMANDS.contains(this);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("(").append(this.name);
        if (this.subName != null) {
            str.append(" ").append(this.subName);
        }
        str.append(")");
        return str.toString();
    }
}

