/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body;

import java.util.Map;
import org.apache.eventmesh.common.protocol.http.body.BaseRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.RegRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.UnRegRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.PushMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.ReplyMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchRequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchV2RequestBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageRequestBody;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;

public abstract class Body {
    public abstract Map<String, Object> toMap();

    public static Body buildBody(String requestCode, Map<String, Object> originalMap) throws Exception {
        if (String.valueOf(RequestCode.MSG_BATCH_SEND.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.MSG_BATCH_SEND_V2.getRequestCode()).equals(requestCode)) {
            return SendMessageBatchV2RequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.MSG_SEND_ASYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.MSG_SEND_SYNC.getRequestCode()).equals(requestCode)) {
            return SendMessageRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode()).equals(requestCode)) {
            return PushMessageRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.HTTP_PUSH_CLIENT_SYNC.getRequestCode()).equals(requestCode)) {
            return PushMessageRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.REGISTER.getRequestCode()).equals(requestCode)) {
            return RegRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.UNREGISTER.getRequestCode()).equals(requestCode)) {
            return UnRegRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.SUBSCRIBE.getRequestCode()).equals(requestCode)) {
            return SubscribeRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.UNSUBSCRIBE.getRequestCode()).equals(requestCode)) {
            return UnSubscribeRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.HEARTBEAT.getRequestCode()).equals(requestCode)) {
            return HeartbeatRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.REPLY_MESSAGE.getRequestCode()).equals(requestCode)) {
            return ReplyMessageRequestBody.buildBody(originalMap);
        }
        if (String.valueOf(RequestCode.ADMIN_SHUTDOWN.getRequestCode()).equals(requestCode)) {
            return BaseRequestBody.buildBody(originalMap);
        }
        throw new Exception();
    }
}

