/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.response;

import com.navercorp.pinpoint.bootstrap.context.AttributeRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.response.ResponseAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.response.ServerResponseHeaderRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.StringStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AllServerResponseHeaderRecorder<RESP>
implements ServerResponseHeaderRecorder<RESP> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    public static final String HEADERS_ALL = "HEADERS-ALL";
    private final ResponseAdaptor<RESP> responseAdaptor;

    public AllServerResponseHeaderRecorder(ResponseAdaptor<RESP> responseAdaptor) {
        this.responseAdaptor = Objects.requireNonNull(responseAdaptor, "responseAdaptor");
    }

    public static boolean isRecordAllHeaders(List<String> recordHeaders) {
        return recordHeaders.contains(HEADERS_ALL);
    }

    @Override
    public void recordHeader(AttributeRecorder recorder, RESP response) {
        for (String headerName : this.getHeaderNames(response)) {
            Collection<String> headers;
            if (StringUtils.isEmpty((String)headerName) || CollectionUtils.isEmpty(headers = this.responseAdaptor.getHeaderNames(response))) continue;
            StringStringValue header = new StringStringValue(headerName, this.formatHeaderValues(headers));
            recorder.recordAttribute(AnnotationKey.HTTP_RESPONSE_HEADER, (DataType)header);
        }
    }

    private Set<String> getHeaderNames(RESP response) {
        Collection<String> headerNames = this.responseAdaptor.getHeaderNames(response);
        if (CollectionUtils.isEmpty(headerNames)) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>(headerNames.size());
        names.addAll(headerNames);
        return names;
    }

    private String formatHeaderValues(Collection<String> headers) {
        if (headers.size() == 1) {
            return headers.iterator().next();
        }
        return headers.toString();
    }
}

