/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.CookieAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.CookieSupportAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerCookieRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.StringStringValue;
import java.util.List;
import java.util.Objects;

public class DefaultServerCookieRecorder<REQ>
implements ServerCookieRecorder<REQ> {
    private final CookieSupportAdaptor<REQ> requestAdaptor;
    private final String[] recordCookies;

    public DefaultServerCookieRecorder(CookieSupportAdaptor<REQ> requestAdaptor, List<String> recordCookies) {
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
        Objects.requireNonNull(recordCookies, "recordCookies");
        this.recordCookies = recordCookies.toArray(new String[0]);
    }

    @Override
    public void recordCookie(SpanRecorder recorder, REQ request) {
        List<CookieAdaptor> cookieList = this.requestAdaptor.getCookie(request, this.recordCookies);
        if (CollectionUtils.isEmpty(cookieList)) {
            return;
        }
        for (CookieAdaptor cookieAdaptor : cookieList) {
            StringStringValue cookie = new StringStringValue(cookieAdaptor.getName(), cookieAdaptor.getValue());
            recorder.recordAttribute(AnnotationKey.HTTP_COOKIE, (DataType)cookie);
        }
    }
}

