/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;

public class DriverConnectInterceptorV2
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final ServiceType serviceType;
    private final boolean recordConnection;

    public DriverConnectInterceptorV2(TraceContext context, MethodDescriptor descriptor, ServiceType serviceType) {
        this(context, descriptor, serviceType, true);
    }

    public DriverConnectInterceptorV2(TraceContext context, MethodDescriptor descriptor, ServiceType serviceType, boolean recordConnection) {
        super(context, descriptor);
        this.serviceType = serviceType;
        this.recordConnection = recordConnection;
    }

    @Override
    protected void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, null);
    }

    @Override
    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    @Override
    protected void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, null, result, throwable);
    }

    @Override
    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
        boolean success = InterceptorUtils.isSuccess(throwable);
        String driverUrl = (String)args[0];
        DatabaseInfo databaseInfo = this.traceContext.getJdbcContext().parseJdbcUrl(this.serviceType, driverUrl);
        if (success && this.recordConnection && result instanceof DatabaseInfoAccessor) {
            ((DatabaseInfoAccessor)result)._$PINPOINT$_setDatabaseInfo(databaseInfo);
        }
    }

    @Override
    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        if (this.recordConnection) {
            DatabaseInfo databaseInfo = result instanceof DatabaseInfoAccessor ? ((DatabaseInfoAccessor)result)._$PINPOINT$_getDatabaseInfo() : null;
            if (databaseInfo == null) {
                databaseInfo = UnKnownDatabaseInfo.INSTANCE;
            }
            recorder.recordServiceType(databaseInfo.getType());
            recorder.recordEndPoint(databaseInfo.getMultipleHost());
            recorder.recordDestinationId(databaseInfo.getDatabaseId());
        }
        String driverUrl = (String)args[0];
        recorder.recordApiCachedString(this.methodDescriptor, driverUrl, 0);
        recorder.recordException(throwable);
    }
}

