/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.scope;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor2;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.util.Objects;

public class ScopedInterceptor2
implements AroundInterceptor2 {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean debugEnabled = this.logger.isDebugEnabled();
    private final AroundInterceptor2 interceptor;
    private final InterceptorScope scope;
    private final ExecutionPolicy policy;

    public ScopedInterceptor2(AroundInterceptor2 interceptor, InterceptorScope scope, ExecutionPolicy policy) {
        this.interceptor = Objects.requireNonNull(interceptor, "interceptor");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.policy = Objects.requireNonNull(policy, "policy");
    }

    @Override
    public void before(Object target, Object arg0, Object arg1) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.tryEnter(this.policy)) {
            this.interceptor.before(target, arg0, arg1);
        } else if (this.debugEnabled) {
            this.logger.debug("tryBefore() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }

    @Override
    public void after(Object target, Object arg0, Object arg1, Object result, Throwable throwable) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.canLeave(this.policy)) {
            this.interceptor.after(target, arg0, arg1, result, throwable);
            transaction.leave(this.policy);
        } else if (this.debugEnabled) {
            this.logger.debug("tryAfter() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }
}

