/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operand;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.ClassUtils;
import java.util.Objects;

@InterfaceStability.Unstable
public class SuperClassInternalNameMatcherOperand
extends AbstractMatcherOperand {
    private final String superClassInternalName;
    private final boolean considerHierarchy;
    private final boolean javaPackage;

    public SuperClassInternalNameMatcherOperand(String superClassName, boolean considerHierarchy) {
        Objects.requireNonNull(superClassName, "superClassName");
        this.superClassInternalName = ClassUtils.toInternalName((String)superClassName);
        this.considerHierarchy = considerHierarchy;
        this.javaPackage = this.superClassInternalName.startsWith("java/");
    }

    public String getSuperClassInternalNames() {
        return this.superClassInternalName;
    }

    public boolean isConsiderHierarchy() {
        return this.considerHierarchy;
    }

    public boolean match(String superClassInternalName) {
        if (superClassInternalName == null) {
            return false;
        }
        return this.superClassInternalName.equals(superClassInternalName);
    }

    public boolean isJavaPackage() {
        return this.javaPackage;
    }

    @Override
    public int getExecutionCost() {
        return this.considerHierarchy ? 5 : 2;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("superClassInternalName=").append(this.superClassInternalName);
        sb.append(", considerHierarchy=").append(this.considerHierarchy);
        sb.append('}');
        return sb.toString();
    }
}

