/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.eventmesh.common.config.convert.ConvertInfo;
import org.apache.eventmesh.common.config.convert.ConvertValue;
import org.apache.eventmesh.common.config.convert.ConverterMap;

public class MapConverter
implements ConvertValue<Map<String, Object>> {
    @Override
    public boolean canHandleNullValue() {
        return true;
    }

    @Override
    public Map<String, Object> convert(ConvertInfo convertInfo) {
        try {
            String key = convertInfo.getKey() + convertInfo.getHump();
            Map map = Objects.equals(Map.class, convertInfo.getField().getType()) ? new HashMap() : (Map)convertInfo.getField().getType().newInstance();
            Type parameterizedType = ((ParameterizedType)convertInfo.getField().getGenericType()).getActualTypeArguments()[1];
            ConvertValue<?> clazzConverter = ConverterMap.getClazzConverter((Class)parameterizedType);
            for (Map.Entry<Object, Object> entry : convertInfo.getProperties().entrySet()) {
                String propertiesKey = entry.getKey().toString();
                if (!propertiesKey.startsWith(key)) continue;
                String value = entry.getValue().toString();
                convertInfo.setValue(value);
                map.put((String)propertiesKey.replace(key, ""), clazzConverter.convert(convertInfo));
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

