/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.zipkin;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.trace.api.AbstractTraceService;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.zipkin.config.ZipkinConfiguration;

@Config.Configs(value={@Config(field="zipkinConfiguration"), @Config(field="exporterConfiguration")})
public class ZipkinTraceService
extends AbstractTraceService {
    private transient ZipkinConfiguration zipkinConfiguration;
    private transient ZipkinSpanExporter zipkinExporter;

    public void init() {
        String eventMeshZipkinIP = this.zipkinConfiguration.getEventMeshZipkinIP();
        int eventMeshZipkinPort = this.zipkinConfiguration.getEventMeshZipkinPort();
        int eventMeshTraceExportInterval = this.exporterConfiguration.getEventMeshTraceExportInterval();
        int eventMeshTraceExportTimeout = this.exporterConfiguration.getEventMeshTraceExportTimeout();
        int eventMeshTraceMaxExportSize = this.exporterConfiguration.getEventMeshTraceMaxExportSize();
        int eventMeshTraceMaxQueueSize = this.exporterConfiguration.getEventMeshTraceMaxQueueSize();
        String httpUrl = String.format("http://%s:%s", eventMeshZipkinIP, eventMeshZipkinPort);
        this.zipkinExporter = ZipkinSpanExporter.builder().setEndpoint(httpUrl + "/api/v2/spans").build();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)this.zipkinExporter).setScheduleDelay((long)eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout((long)eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(eventMeshTraceMaxExportSize).setMaxQueueSize(eventMeshTraceMaxQueueSize).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        this.initVars((SpanProcessor)spanProcessor, serviceNameResource);
    }

    public void shutdown() throws TraceException {
        Exception ex = null;
        try {
            if (this.sdkTracerProvider != null) {
                this.sdkTracerProvider.close();
            }
        }
        catch (Exception e) {
            ex = e;
        }
        try {
            if (this.zipkinExporter != null) {
                this.zipkinExporter.close();
            }
        }
        catch (Exception e) {
            ex = e;
        }
        if (ex != null) {
            throw new TraceException("trace close error", (Throwable)ex);
        }
    }

    public ZipkinConfiguration getClientConfiguration() {
        return this.zipkinConfiguration;
    }

    public ZipkinConfiguration getZipkinConfiguration() {
        return this.zipkinConfiguration;
    }

    public ZipkinSpanExporter getZipkinExporter() {
        return this.zipkinExporter;
    }

    public void setZipkinConfiguration(ZipkinConfiguration zipkinConfiguration) {
        this.zipkinConfiguration = zipkinConfiguration;
    }

    public void setZipkinExporter(ZipkinSpanExporter zipkinExporter) {
        this.zipkinExporter = zipkinExporter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinTraceService)) {
            return false;
        }
        ZipkinTraceService other = (ZipkinTraceService)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZipkinTraceService;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ZipkinTraceService(zipkinConfiguration=" + this.getZipkinConfiguration() + ", zipkinExporter=" + this.getZipkinExporter() + ")";
    }
}

