/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.util;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.SessionState;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");

    public static void writeAndFlush(Package pkg, long startTime, long taskExecuteTime, ChannelHandlerContext ctx, Session session) {
        try {
            UserAgent user;
            UserAgent userAgent = user = session == null ? null : session.getClient();
            if (session != null && session.getSessionState() == SessionState.CLOSED) {
                Utils.logFailedMessageFlow(pkg, user, startTime, taskExecuteTime, new Exception("the session has been closed"));
                return;
            }
            ctx.writeAndFlush((Object)pkg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    Utils.logFailedMessageFlow(future, pkg, user, startTime, taskExecuteTime);
                } else {
                    Utils.logSucceedMessageFlow(pkg, user, startTime, taskExecuteTime);
                    if (session != null) {
                        ((ClientGroupWrapper)Objects.requireNonNull(session.getClientGroupWrapper().get())).getEventMeshTcpMonitor().getTcpSummaryMetrics().getEventMesh2clientMsgNum().incrementAndGet();
                    }
                }
            }));
        }
        catch (Exception e) {
            log.error("exception while sending message to client", (Throwable)e);
        }
    }

    public static void logFailedMessageFlow(ChannelFuture future, Package pkg, UserAgent user, long startTime, long taskExecuteTime) {
        Utils.logFailedMessageFlow(pkg, user, startTime, taskExecuteTime, future.cause());
    }

    private static void logFailedMessageFlow(Package pkg, UserAgent user, long startTime, long taskExecuteTime, Throwable e) {
        if (pkg.getBody() instanceof EventMeshMessage) {
            String mqMessage = EventMeshUtil.printMqMessage((EventMeshMessage)pkg.getBody());
            MESSAGE_LOGGER.error("pkg|eventMesh2c|failed|cmd={}|mqMsg={}|user={}|wait={}ms|cost={}ms|errMsg={}", new Object[]{pkg.getHeader().getCmd(), mqMessage, user, taskExecuteTime - startTime, System.currentTimeMillis() - startTime, e});
        } else {
            MESSAGE_LOGGER.error("pkg|eventMesh2c|failed|cmd={}|pkg={}|user={}|wait={}ms|cost={}ms|errMsg={}", new Object[]{pkg.getHeader().getCmd(), pkg, user, taskExecuteTime - startTime, System.currentTimeMillis() - startTime, e});
        }
    }

    public static void logSucceedMessageFlow(Package pkg, UserAgent user, long startTime, long taskExecuteTime) {
        if (pkg.getBody() instanceof EventMeshMessage) {
            String mqMessage = EventMeshUtil.printMqMessage((EventMeshMessage)pkg.getBody());
            MESSAGE_LOGGER.info("pkg|eventMesh2c|cmd={}|mqMsg={}|user={}|wait={}ms|cost={}ms", new Object[]{pkg.getHeader().getCmd(), mqMessage, user, taskExecuteTime - startTime, System.currentTimeMillis() - startTime});
        } else {
            MESSAGE_LOGGER.info("pkg|eventMesh2c|cmd={}|pkg={}|user={}|wait={}ms|cost={}ms", new Object[]{pkg.getHeader().getCmd(), pkg, user, taskExecuteTime - startTime, System.currentTimeMillis() - startTime});
        }
    }

    public static String getServiceId(String topic) {
        String[] topicStrArr = topic.split("-");
        if (topicStrArr.length >= 3) {
            return topicStrArr[2];
        }
        return null;
    }

    public static Map<String, Object> parseHttpHeader(HttpRequest fullReq) {
        HashMap<String, Object> headerParam = new HashMap<String, Object>();
        for (String key : fullReq.headers().names()) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)key, (CharSequence[])new CharSequence[]{HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderNames.ACCEPT_ENCODING.toString(), HttpHeaderNames.CONTENT_LENGTH.toString()})) continue;
            headerParam.put(key, fullReq.headers().get(key));
        }
        return headerParam;
    }
}

