/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.api.registry.bo.EventMeshServicePubTopicInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.spi.EventMeshExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registry {
    private static final Logger log = LoggerFactory.getLogger(Registry.class);
    private static final Map<String, Registry> REGISTRY_CACHE = new HashMap<String, Registry>(16);
    private RegistryService registryService;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    private Registry() {
    }

    public static Registry getInstance(String registryPluginType) {
        return REGISTRY_CACHE.computeIfAbsent(registryPluginType, Registry::registryBuilder);
    }

    private static Registry registryBuilder(String registryPluginType) {
        RegistryService registryServiceExt = (RegistryService)EventMeshExtensionFactory.getExtension(RegistryService.class, (String)registryPluginType);
        if (registryServiceExt == null) {
            String errorMsg = "can't load the registryService plugin, please check.";
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        Registry registry = new Registry();
        registry.registryService = registryServiceExt;
        return registry;
    }

    public void init() throws RegistryException {
        if (!this.inited.compareAndSet(false, true)) {
            return;
        }
        this.registryService.init();
    }

    public void start() throws RegistryException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.registryService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws RegistryException {
        this.inited.compareAndSet(true, false);
        this.started.compareAndSet(true, false);
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        Registry registry = this;
        synchronized (registry) {
            this.registryService.shutdown();
        }
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        return this.registryService.findEventMeshInfoByCluster(clusterName);
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        return this.registryService.findAllEventMeshInfo();
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws RegistryException {
        return this.registryService.findEventMeshClientDistributionData(clusterName, group, purpose);
    }

    public void registerMetadata(Map<String, String> metadata) {
        this.registryService.registerMetadata(metadata);
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        return this.registryService.register(eventMeshRegisterInfo);
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        return this.registryService.unRegister(eventMeshUnRegisterInfo);
    }

    public List<EventMeshServicePubTopicInfo> findEventMeshServicePubTopicInfos() throws Exception {
        return this.registryService.findEventMeshServicePubTopicInfos();
    }

    public EventMeshAppSubTopicInfo findEventMeshAppSubTopicInfo(String group) throws Exception {
        return this.registryService.findEventMeshAppSubTopicInfoByGroup(group);
    }
}

