/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReusableLatch {
    private final Semaphore impl;
    private final AtomicBoolean released;
    private final Object releasingLock = new Object();

    public ReusableLatch() {
        this(false);
    }

    public ReusableLatch(boolean startReleased) {
        this.released = new AtomicBoolean(startReleased);
        this.impl = startReleased ? new Semaphore(Integer.MAX_VALUE) : new Semaphore(0);
    }

    public void await() throws InterruptedException {
        if (this.released.get()) {
            return;
        }
        this.impl.acquire();
    }

    public void await(long timeoutMillis) throws InterruptedException, TimeoutException {
        if (this.released.get()) {
            return;
        }
        if (!this.impl.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Timeout expired prior to latch becoming available.");
        }
    }

    public void awaitUninterruptibly() {
        if (this.released.get()) {
            return;
        }
        this.impl.acquireUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.released.compareAndSet(false, true)) {
            Object object = this.releasingLock;
            synchronized (object) {
                if (this.released.get()) {
                    this.impl.release(Integer.MAX_VALUE);
                }
            }
        }
    }

    public boolean isReleased() {
        return this.released.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.released.compareAndSet(true, false)) {
            Object object = this.releasingLock;
            synchronized (object) {
                if (!this.released.get()) {
                    this.impl.drainPermits();
                }
            }
        }
    }

    public int getQueueLength() {
        return this.impl.getQueueLength();
    }

    public String toString() {
        return "LatchReleased: " + this.released.get();
    }
}

