/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.util.AbstractDrainingQueue;
import io.pravega.common.util.SimpleDeque;
import java.util.Queue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BlockingDrainingQueue<T>
extends AbstractDrainingQueue<T> {
    private final SimpleDeque<T> contents = new SimpleDeque();

    @Override
    protected void addInternal(T item) {
        this.contents.addLast(item);
    }

    @Override
    protected int sizeInternal() {
        return this.contents.size();
    }

    @Override
    protected T peekInternal() {
        return this.contents.peekFirst();
    }

    @Override
    protected Queue<T> fetch(int maxCount) {
        return this.contents.pollFirst(maxCount);
    }
}

