/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.client.tables.KeyValueTableIterator;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.impl.SegmentIteratorArgs;
import io.pravega.client.tables.impl.TableEntryHelper;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

class KeyValueTableIteratorImpl
implements KeyValueTableIterator {
    @NonNull
    private final ByteBuffer fromPrimaryKey;
    @NonNull
    private final ByteBuffer fromSecondaryKey;
    @NonNull
    private final ByteBuffer toPrimaryKey;
    @NonNull
    private final ByteBuffer toSecondaryKey;
    private final int maxIterationSize;
    @NonNull
    private final TableEntryHelper entryConverter;
    @NonNull
    private final Executor executor;

    boolean isSingleSegment() {
        return this.fromPrimaryKey.equals(this.toPrimaryKey);
    }

    @Override
    public AsyncIterator<IteratorItem<TableKey>> keys() {
        return this.isSingleSegment() ? this.singleSegmentKeys() : this.multiSegmentKeys();
    }

    @Override
    public AsyncIterator<IteratorItem<TableEntry>> entries() {
        return this.isSingleSegment() ? this.singleSegmentEntries() : this.multiSegmentEntries();
    }

    private AsyncIterator<IteratorItem<TableKey>> singleSegmentKeys() {
        assert (this.fromPrimaryKey.equals(this.toPrimaryKey));
        return this.singleSegmentKeys(this.entryConverter.getSelector().getTableSegment(this.fromPrimaryKey));
    }

    private AsyncIterator<IteratorItem<TableKey>> singleSegmentKeys(TableSegment ts) {
        return this.singleSegmentIterator(ts.keyIterator(this.getIteratorArgs()), this.entryConverter::fromTableSegmentKey);
    }

    private AsyncIterator<IteratorItem<TableEntry>> singleSegmentEntries() {
        assert (this.fromPrimaryKey.equals(this.toPrimaryKey));
        return this.singleSegmentEntries(this.entryConverter.getSelector().getTableSegment(this.fromPrimaryKey));
    }

    private AsyncIterator<IteratorItem<TableEntry>> singleSegmentEntries(TableSegment ts) {
        return this.singleSegmentIterator(ts.entryIterator(this.getIteratorArgs()), e -> this.entryConverter.fromTableSegmentEntry(ts, (TableSegmentEntry)e));
    }

    private <T, V> AsyncIterator<IteratorItem<V>> singleSegmentIterator(AsyncIterator<IteratorItem<T>> tsIterator, Function<T, V> convert) {
        return tsIterator.thenApply(si -> {
            List entries = si.getItems().stream().map(convert).collect(Collectors.toList());
            return new IteratorItem(entries);
        });
    }

    private AsyncIterator<IteratorItem<TableKey>> multiSegmentKeys() {
        return this.multiSegment(this::singleSegmentKeys, k -> k);
    }

    private AsyncIterator<IteratorItem<TableEntry>> multiSegmentEntries() {
        return this.multiSegment(this::singleSegmentEntries, TableEntry::getKey);
    }

    private <T> AsyncIterator<IteratorItem<T>> multiSegment(Function<TableSegment, AsyncIterator<IteratorItem<T>>> segmentIterator, Function<T, TableKey> getKey) {
        Iterator segmentIterators = this.entryConverter.getSelector().getAllTableSegments().stream().map(segmentIterator).iterator();
        return new MergeAsyncIterator(segmentIterators, getKey, this.maxIterationSize, this.executor).asSequential(this.executor);
    }

    private SegmentIteratorArgs getIteratorArgs() {
        return SegmentIteratorArgs.builder().maxItemsAtOnce(this.maxIterationSize).fromKey(this.entryConverter.serializeKey(this.fromPrimaryKey, this.fromSecondaryKey)).toKey(this.entryConverter.serializeKey(this.toPrimaryKey, this.toSecondaryKey)).build();
    }

    @ConstructorProperties(value={"fromPrimaryKey", "fromSecondaryKey", "toPrimaryKey", "toSecondaryKey", "maxIterationSize", "entryConverter", "executor"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableIteratorImpl(@NonNull ByteBuffer fromPrimaryKey, @NonNull ByteBuffer fromSecondaryKey, @NonNull ByteBuffer toPrimaryKey, @NonNull ByteBuffer toSecondaryKey, int maxIterationSize, @NonNull TableEntryHelper entryConverter, @NonNull Executor executor) {
        if (fromPrimaryKey == null) {
            throw new NullPointerException("fromPrimaryKey is marked non-null but is null");
        }
        if (fromSecondaryKey == null) {
            throw new NullPointerException("fromSecondaryKey is marked non-null but is null");
        }
        if (toPrimaryKey == null) {
            throw new NullPointerException("toPrimaryKey is marked non-null but is null");
        }
        if (toSecondaryKey == null) {
            throw new NullPointerException("toSecondaryKey is marked non-null but is null");
        }
        if (entryConverter == null) {
            throw new NullPointerException("entryConverter is marked non-null but is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is marked non-null but is null");
        }
        this.fromPrimaryKey = fromPrimaryKey;
        this.fromSecondaryKey = fromSecondaryKey;
        this.toPrimaryKey = toPrimaryKey;
        this.toSecondaryKey = toSecondaryKey;
        this.maxIterationSize = maxIterationSize;
        this.entryConverter = entryConverter;
        this.executor = executor;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuffer getFromPrimaryKey() {
        return this.fromPrimaryKey;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuffer getFromSecondaryKey() {
        return this.fromSecondaryKey;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuffer getToPrimaryKey() {
        return this.toPrimaryKey;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuffer getToSecondaryKey() {
        return this.toSecondaryKey;
    }

    static class Builder
    implements KeyValueTableIterator.Builder {
        @VisibleForTesting
        static final byte MIN_BYTE = 0;
        @VisibleForTesting
        static final byte MAX_BYTE = -1;
        @NonNull
        private final KeyValueTableConfiguration kvtConfig;
        @NonNull
        private final TableEntryHelper entryConverter;
        @NonNull
        private final Executor executor;
        private int maxIterationSize = 10;

        @Override
        public KeyValueTableIterator.Builder maxIterationSize(int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be a positive integer");
            this.maxIterationSize = size;
            return this;
        }

        @Override
        public KeyValueTableIteratorImpl forPrimaryKey(@NonNull ByteBuffer primaryKey) {
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is marked non-null but is null");
            }
            return this.forPrimaryKey(primaryKey, null, null);
        }

        @Override
        public KeyValueTableIteratorImpl forPrimaryKey(@NonNull ByteBuffer primaryKey, ByteBuffer fromSecondaryKey, ByteBuffer toSecondaryKey) {
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is marked non-null but is null");
            }
            this.validateExact(primaryKey, this.kvtConfig.getPrimaryKeyLength(), "Primary Key");
            this.validateExact(fromSecondaryKey, this.kvtConfig.getSecondaryKeyLength(), "From Secondary Key");
            this.validateExact(toSecondaryKey, this.kvtConfig.getSecondaryKeyLength(), "To Secondary Key");
            fromSecondaryKey = this.pad(fromSecondaryKey, (byte)0, this.kvtConfig.getSecondaryKeyLength());
            toSecondaryKey = this.pad(toSecondaryKey, (byte)-1, this.kvtConfig.getSecondaryKeyLength());
            return new KeyValueTableIteratorImpl(primaryKey, fromSecondaryKey, primaryKey, toSecondaryKey, this.maxIterationSize, this.entryConverter, this.executor);
        }

        @Override
        public KeyValueTableIteratorImpl forPrimaryKey(@NonNull ByteBuffer primaryKey, ByteBuffer secondaryKeyPrefix) {
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is marked non-null but is null");
            }
            this.validateExact(primaryKey, this.kvtConfig.getPrimaryKeyLength(), "Primary Key");
            this.validateAtMost(secondaryKeyPrefix, this.kvtConfig.getSecondaryKeyLength(), "Secondary Key Prefix");
            ByteBuffer fromSecondaryKey = this.pad(secondaryKeyPrefix, (byte)0, this.kvtConfig.getSecondaryKeyLength());
            ByteBuffer toSecondaryKey = this.pad(secondaryKeyPrefix, (byte)-1, this.kvtConfig.getSecondaryKeyLength());
            return new KeyValueTableIteratorImpl(primaryKey, fromSecondaryKey, primaryKey, toSecondaryKey, this.maxIterationSize, this.entryConverter, this.executor);
        }

        @Override
        public KeyValueTableIteratorImpl forRange(ByteBuffer fromPrimaryKey, ByteBuffer toPrimaryKey) {
            this.validateExact(fromPrimaryKey, this.kvtConfig.getPrimaryKeyLength(), "From Primary Key");
            this.validateExact(toPrimaryKey, this.kvtConfig.getPrimaryKeyLength(), "To Primary Key");
            fromPrimaryKey = this.pad(fromPrimaryKey, (byte)0, this.kvtConfig.getPrimaryKeyLength());
            toPrimaryKey = this.pad(toPrimaryKey, (byte)-1, this.kvtConfig.getPrimaryKeyLength());
            ByteBuffer fromSecondaryKey = this.pad(null, (byte)0, this.kvtConfig.getSecondaryKeyLength());
            ByteBuffer toSecondaryKey = this.pad(null, (byte)-1, this.kvtConfig.getSecondaryKeyLength());
            return new KeyValueTableIteratorImpl(fromPrimaryKey, fromSecondaryKey, toPrimaryKey, toSecondaryKey, this.maxIterationSize, this.entryConverter, this.executor);
        }

        @Override
        public KeyValueTableIteratorImpl forPrefix(ByteBuffer primaryKeyPrefix) {
            this.validateAtMost(primaryKeyPrefix, this.kvtConfig.getPrimaryKeyLength(), "Primary Key Prefix");
            ByteBuffer fromPrimaryKey = this.pad(primaryKeyPrefix, (byte)0, this.kvtConfig.getPrimaryKeyLength());
            ByteBuffer toPrimaryKey = this.pad(primaryKeyPrefix, (byte)-1, this.kvtConfig.getPrimaryKeyLength());
            ByteBuffer fromSecondaryKey = this.pad(null, (byte)0, this.kvtConfig.getSecondaryKeyLength());
            ByteBuffer toSecondaryKey = this.pad(null, (byte)-1, this.kvtConfig.getSecondaryKeyLength());
            return new KeyValueTableIteratorImpl(fromPrimaryKey, fromSecondaryKey, toPrimaryKey, toSecondaryKey, this.maxIterationSize, this.entryConverter, this.executor);
        }

        @Override
        public KeyValueTableIteratorImpl all() {
            return this.forRange(null, null);
        }

        private ByteBuffer pad(ByteBuffer key, byte value, int size) {
            int startOffset;
            byte[] result;
            if (key == null) {
                result = new byte[size];
                startOffset = 0;
            } else {
                if (key.remaining() == size) {
                    return key.duplicate();
                }
                result = new byte[size];
                startOffset = key.remaining();
                key.duplicate().get(result, 0, startOffset);
            }
            for (int i = startOffset; i < size; ++i) {
                result[i] = value;
            }
            return ByteBuffer.wrap(result);
        }

        private void validateExact(@Nullable ByteBuffer key, int expected, String name) {
            if (key != null) {
                Preconditions.checkArgument((expected == key.remaining() ? 1 : 0) != 0, (String)"%s length must be %s; given %s.", (Object)name, (Object)expected, (Object)key.remaining());
            }
        }

        private void validateAtMost(ByteBuffer key, int maxLength, String name) {
            if (key != null) {
                Preconditions.checkArgument((key.remaining() <= maxLength ? 1 : 0) != 0, (String)"%s length must be at most %s; given %s.", (Object)name, (Object)maxLength, (Object)key.remaining());
            }
        }

        @ConstructorProperties(value={"kvtConfig", "entryConverter", "executor"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Builder(@NonNull KeyValueTableConfiguration kvtConfig, @NonNull TableEntryHelper entryConverter, @NonNull Executor executor) {
            if (kvtConfig == null) {
                throw new NullPointerException("kvtConfig is marked non-null but is null");
            }
            if (entryConverter == null) {
                throw new NullPointerException("entryConverter is marked non-null but is null");
            }
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            this.kvtConfig = kvtConfig;
            this.entryConverter = entryConverter;
            this.executor = executor;
        }
    }

    @VisibleForTesting
    static class TableKeyComparator
    implements Comparator<TableKey> {
        TableKeyComparator() {
        }

        @Override
        public int compare(TableKey k1, TableKey k2) {
            int r = this.compare(k1.getPrimaryKey(), k2.getPrimaryKey());
            if (r == 0 && k1.getSecondaryKey() != null) {
                r = this.compare(k1.getSecondaryKey(), k2.getSecondaryKey());
            }
            return r;
        }

        @Override
        int compare(ByteBuffer b1, ByteBuffer b2) {
            assert (b1.remaining() == b2.remaining());
            for (int i = 0; i < b1.remaining(); ++i) {
                int r = (b1.get(i) & 0xFF) - (b2.get(i) & 0xFF);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }

    @VisibleForTesting
    static class PeekingIteratorItem<T> {
        final T item;
        final TableKey key;

        @ConstructorProperties(value={"item", "key"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PeekingIteratorItem(T item, TableKey key) {
            this.item = item;
            this.key = key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public T getItem() {
            return this.item;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKey getKey() {
            return this.key;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PeekingIteratorItem)) {
                return false;
            }
            PeekingIteratorItem other = (PeekingIteratorItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$item = this.getItem();
            T other$item = other.getItem();
            if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
                return false;
            }
            TableKey this$key = this.getKey();
            TableKey other$key = other.getKey();
            return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PeekingIteratorItem;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $item = this.getItem();
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            TableKey $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KeyValueTableIteratorImpl.PeekingIteratorItem(item=" + this.getItem() + ", key=" + this.getKey() + ")";
        }
    }

    @VisibleForTesting
    static class PeekingIterator<T> {
        private final AsyncIterator<IteratorItem<T>> innerIterator;
        private final Function<T, TableKey> getKey;
        private final AtomicReference<List<PeekingIteratorItem<T>>> currentBatch = new AtomicReference();
        private final AtomicInteger currentBatchIndex = new AtomicInteger();

        PeekingIteratorItem<T> getCurrent() {
            return this.currentBatch.get() == null ? null : this.currentBatch.get().get(this.currentBatchIndex.get());
        }

        boolean hasNext() {
            return this.currentBatch.get() != null;
        }

        CompletableFuture<Void> advance() {
            if (this.currentBatch.get() != null && this.currentBatchIndex.get() < this.currentBatch.get().size() - 1) {
                this.currentBatchIndex.incrementAndGet();
                return CompletableFuture.completedFuture(null);
            }
            return this.innerIterator.getNext().thenAccept(result -> {
                if (result == null || result.getItems().isEmpty()) {
                    this.currentBatch.set(null);
                } else {
                    this.currentBatch.set(result.getItems().stream().map(i -> new PeekingIteratorItem<Object>(i, this.getKey.apply(i))).collect(Collectors.toList()));
                }
                this.currentBatchIndex.set(0);
            });
        }

        @ConstructorProperties(value={"innerIterator", "getKey"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PeekingIterator(AsyncIterator<IteratorItem<T>> innerIterator, Function<T, TableKey> getKey) {
            this.innerIterator = innerIterator;
            this.getKey = getKey;
        }
    }

    @VisibleForTesting
    static class MergeAsyncIterator<T>
    implements AsyncIterator<IteratorItem<T>> {
        private static final TableKeyComparator COMPARATOR = new TableKeyComparator();
        private final CompletableFuture<PriorityQueue<PeekingIterator<T>>> segments;
        private final Function<T, TableKey> getKey;
        private final int maxIterationSize;
        private final Executor executor;

        MergeAsyncIterator(Iterator<AsyncIterator<IteratorItem<T>>> iterators, Function<T, TableKey> getKey, int maxIterationSize, Executor executor) {
            this.getKey = getKey;
            this.maxIterationSize = maxIterationSize;
            this.segments = this.initialize(iterators);
            this.executor = executor;
        }

        public CompletableFuture<IteratorItem<T>> getNext() {
            return this.segments.thenCompose(segments -> {
                if (segments.isEmpty()) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.populateBatch((PriorityQueue<PeekingIterator<T>>)segments);
            });
        }

        private CompletableFuture<IteratorItem<T>> populateBatch(PriorityQueue<PeekingIterator<T>> segments) {
            ArrayList result = new ArrayList();
            return Futures.loop(() -> !segments.isEmpty() && result.size() < this.maxIterationSize, () -> {
                PeekingIterator first = (PeekingIterator)segments.poll();
                result.add(first.getCurrent().getItem());
                return first.advance().thenRun(() -> {
                    if (first.hasNext()) {
                        segments.add(first);
                    }
                });
            }, (Executor)this.executor).thenApply(v -> new IteratorItem(result));
        }

        private CompletableFuture<PriorityQueue<PeekingIterator<T>>> initialize(Iterator<AsyncIterator<IteratorItem<T>>> iterators) {
            HashMap moveFirst = new HashMap();
            while (iterators.hasNext()) {
                PeekingIterator<T> ss = new PeekingIterator<T>(iterators.next(), this.getKey);
                moveFirst.put(ss, ss.advance());
            }
            PriorityQueue result = new PriorityQueue((s1, s2) -> COMPARATOR.compare(s1.getCurrent().getKey(), s2.getCurrent().getKey()));
            return Futures.allOf(moveFirst.values()).thenApply(v -> {
                moveFirst.keySet().stream().filter(PeekingIterator::hasNext).forEach(result::add);
                return result;
            });
        }
    }
}

