/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Checkpoint;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class ReaderGroupConfig
implements Serializable {
    public static final UUID DEFAULT_UUID = new UUID(0L, 0L);
    public static final long DEFAULT_GENERATION = -1L;
    private static final long serialVersionUID = 1L;
    private static final ReaderGroupConfigSerializer SERIALIZER = new ReaderGroupConfigSerializer();
    private final long groupRefreshTimeMillis;
    private final long automaticCheckpointIntervalMillis;
    private final Map<Stream, StreamCut> startingStreamCuts;
    private final Map<Stream, StreamCut> endingStreamCuts;
    private final int maxOutstandingCheckpointRequest;
    private final StreamDataRetention retentionType;
    private final long generation;
    private final UUID readerGroupId;

    public static ReaderGroupConfig cloneConfig(ReaderGroupConfig configToClone, UUID readerGroupId, long generation) {
        return ReaderGroupConfig.builder().readerGroupId(readerGroupId).generation(generation).retentionType(configToClone.getRetentionType()).automaticCheckpointIntervalMillis(configToClone.getAutomaticCheckpointIntervalMillis()).groupRefreshTimeMillis(configToClone.getGroupRefreshTimeMillis()).maxOutstandingCheckpointRequest(configToClone.getMaxOutstandingCheckpointRequest()).startingStreamCuts(configToClone.getStartingStreamCuts()).endingStreamCuts(configToClone.getEndingStreamCuts()).build();
    }

    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static ReaderGroupConfig fromBytes(ByteBuffer buff) {
        return (ReaderGroupConfig)SERIALIZER.deserialize((BufferView)new ByteArraySegment(buff));
    }

    @ConstructorProperties(value={"groupRefreshTimeMillis", "automaticCheckpointIntervalMillis", "startingStreamCuts", "endingStreamCuts", "maxOutstandingCheckpointRequest", "retentionType", "generation", "readerGroupId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    ReaderGroupConfig(long groupRefreshTimeMillis, long automaticCheckpointIntervalMillis, Map<Stream, StreamCut> startingStreamCuts, Map<Stream, StreamCut> endingStreamCuts, int maxOutstandingCheckpointRequest, StreamDataRetention retentionType, long generation, UUID readerGroupId) {
        this.groupRefreshTimeMillis = groupRefreshTimeMillis;
        this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
        this.startingStreamCuts = startingStreamCuts;
        this.endingStreamCuts = endingStreamCuts;
        this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
        this.retentionType = retentionType;
        this.generation = generation;
        this.readerGroupId = readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ReaderGroupConfigBuilder builder() {
        return new ReaderGroupConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReaderGroupConfigBuilder toBuilder() {
        return new ReaderGroupConfigBuilder().groupRefreshTimeMillis(this.groupRefreshTimeMillis).automaticCheckpointIntervalMillis(this.automaticCheckpointIntervalMillis).startingStreamCuts(this.startingStreamCuts).endingStreamCuts(this.endingStreamCuts).maxOutstandingCheckpointRequest(this.maxOutstandingCheckpointRequest).retentionType(this.retentionType).generation(this.generation).readerGroupId(this.readerGroupId);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGroupRefreshTimeMillis() {
        return this.groupRefreshTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Stream, StreamCut> getStartingStreamCuts() {
        return this.startingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Stream, StreamCut> getEndingStreamCuts() {
        return this.endingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxOutstandingCheckpointRequest() {
        return this.maxOutstandingCheckpointRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StreamDataRetention getRetentionType() {
        return this.retentionType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGeneration() {
        return this.generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getReaderGroupId() {
        return this.readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ReaderGroupConfig(groupRefreshTimeMillis=" + this.getGroupRefreshTimeMillis() + ", automaticCheckpointIntervalMillis=" + this.getAutomaticCheckpointIntervalMillis() + ", startingStreamCuts=" + this.getStartingStreamCuts() + ", endingStreamCuts=" + this.getEndingStreamCuts() + ", maxOutstandingCheckpointRequest=" + this.getMaxOutstandingCheckpointRequest() + ", retentionType=" + (Object)((Object)this.getRetentionType()) + ", generation=" + this.getGeneration() + ", readerGroupId=" + this.getReaderGroupId() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReaderGroupConfig)) {
            return false;
        }
        ReaderGroupConfig other = (ReaderGroupConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGroupRefreshTimeMillis() != other.getGroupRefreshTimeMillis()) {
            return false;
        }
        if (this.getAutomaticCheckpointIntervalMillis() != other.getAutomaticCheckpointIntervalMillis()) {
            return false;
        }
        Map<Stream, StreamCut> this$startingStreamCuts = this.getStartingStreamCuts();
        Map<Stream, StreamCut> other$startingStreamCuts = other.getStartingStreamCuts();
        if (this$startingStreamCuts == null ? other$startingStreamCuts != null : !((Object)this$startingStreamCuts).equals(other$startingStreamCuts)) {
            return false;
        }
        Map<Stream, StreamCut> this$endingStreamCuts = this.getEndingStreamCuts();
        Map<Stream, StreamCut> other$endingStreamCuts = other.getEndingStreamCuts();
        if (this$endingStreamCuts == null ? other$endingStreamCuts != null : !((Object)this$endingStreamCuts).equals(other$endingStreamCuts)) {
            return false;
        }
        if (this.getMaxOutstandingCheckpointRequest() != other.getMaxOutstandingCheckpointRequest()) {
            return false;
        }
        StreamDataRetention this$retentionType = this.getRetentionType();
        StreamDataRetention other$retentionType = other.getRetentionType();
        return !(this$retentionType == null ? other$retentionType != null : !((Object)((Object)this$retentionType)).equals((Object)other$retentionType));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReaderGroupConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $groupRefreshTimeMillis = this.getGroupRefreshTimeMillis();
        result = result * 59 + (int)($groupRefreshTimeMillis >>> 32 ^ $groupRefreshTimeMillis);
        long $automaticCheckpointIntervalMillis = this.getAutomaticCheckpointIntervalMillis();
        result = result * 59 + (int)($automaticCheckpointIntervalMillis >>> 32 ^ $automaticCheckpointIntervalMillis);
        Map<Stream, StreamCut> $startingStreamCuts = this.getStartingStreamCuts();
        result = result * 59 + ($startingStreamCuts == null ? 43 : ((Object)$startingStreamCuts).hashCode());
        Map<Stream, StreamCut> $endingStreamCuts = this.getEndingStreamCuts();
        result = result * 59 + ($endingStreamCuts == null ? 43 : ((Object)$endingStreamCuts).hashCode());
        result = result * 59 + this.getMaxOutstandingCheckpointRequest();
        StreamDataRetention $retentionType = this.getRetentionType();
        result = result * 59 + ($retentionType == null ? 43 : ((Object)((Object)$retentionType)).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getAutomaticCheckpointIntervalMillis() {
        return this.automaticCheckpointIntervalMillis;
    }

    private static class ReaderGroupConfigSerializer
    extends VersionedSerializer.WithBuilder<ReaderGroupConfig, ReaderGroupConfigBuilder> {
        private ReaderGroupConfigSerializer() {
        }

        protected ReaderGroupConfigBuilder newBuilder() {
            return ReaderGroupConfig.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
            this.version(0).revision(1, this::write01, this::read01);
            this.version(0).revision(2, this::write02, this::read02);
        }

        private void read00(RevisionDataInput revisionDataInput, ReaderGroupConfigBuilder builder) throws IOException {
            builder.automaticCheckpointIntervalMillis(revisionDataInput.readLong());
            builder.groupRefreshTimeMillis(revisionDataInput.readLong());
            RevisionDataInput.ElementDeserializer keyDeserializer = in -> Stream.of(in.readUTF());
            RevisionDataInput.ElementDeserializer valueDeserializer = in -> StreamCut.fromBytes(ByteBuffer.wrap(in.readArray()));
            builder.startFromStreamCuts(revisionDataInput.readMap(keyDeserializer, valueDeserializer));
            builder.endingStreamCuts(revisionDataInput.readMap(keyDeserializer, valueDeserializer));
        }

        private void write00(ReaderGroupConfig object, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(object.getAutomaticCheckpointIntervalMillis());
            revisionDataOutput.writeLong(object.getGroupRefreshTimeMillis());
            RevisionDataOutput.ElementSerializer keySerializer = (out, s) -> out.writeUTF(s.getScopedName());
            RevisionDataOutput.ElementSerializer valueSerializer = (out, cut) -> out.writeBuffer((BufferView)new ByteArraySegment(cut.toBytes()));
            revisionDataOutput.writeMap(object.startingStreamCuts, keySerializer, valueSerializer);
            revisionDataOutput.writeMap(object.endingStreamCuts, keySerializer, valueSerializer);
        }

        private void read01(RevisionDataInput revisionDataInput, ReaderGroupConfigBuilder builder) throws IOException {
            builder.automaticCheckpointIntervalMillis(revisionDataInput.readLong());
            builder.groupRefreshTimeMillis(revisionDataInput.readLong());
            RevisionDataInput.ElementDeserializer keyDeserializer = in -> Stream.of(in.readUTF());
            RevisionDataInput.ElementDeserializer valueDeserializer = in -> StreamCut.fromBytes(ByteBuffer.wrap(in.readArray()));
            builder.startFromStreamCuts(revisionDataInput.readMap(keyDeserializer, valueDeserializer));
            builder.endingStreamCuts(revisionDataInput.readMap(keyDeserializer, valueDeserializer));
            builder.maxOutstandingCheckpointRequest(revisionDataInput.readInt());
        }

        private void write01(ReaderGroupConfig object, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(object.getAutomaticCheckpointIntervalMillis());
            revisionDataOutput.writeLong(object.getGroupRefreshTimeMillis());
            RevisionDataOutput.ElementSerializer keySerializer = (out, s) -> out.writeUTF(s.getScopedName());
            RevisionDataOutput.ElementSerializer valueSerializer = (out, cut) -> out.writeBuffer((BufferView)new ByteArraySegment(cut.toBytes()));
            revisionDataOutput.writeMap(object.startingStreamCuts, keySerializer, valueSerializer);
            revisionDataOutput.writeMap(object.endingStreamCuts, keySerializer, valueSerializer);
            revisionDataOutput.writeInt(object.getMaxOutstandingCheckpointRequest());
        }

        private void read02(RevisionDataInput revisionDataInput, ReaderGroupConfigBuilder builder) throws IOException {
            int ordinal = revisionDataInput.readCompactInt();
            builder.retentionType(StreamDataRetention.values()[ordinal]);
            builder.generation(revisionDataInput.readLong());
            builder.readerGroupId(revisionDataInput.readUUID());
        }

        private void write02(ReaderGroupConfig object, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeCompactInt(object.retentionType.ordinal());
            revisionDataOutput.writeLong(object.getGeneration());
            revisionDataOutput.writeUUID(object.getReaderGroupId());
        }
    }

    public static class ReaderGroupConfigBuilder
    implements ObjectBuilder<ReaderGroupConfig> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Stream, StreamCut> startingStreamCuts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Stream, StreamCut> endingStreamCuts;
        private long groupRefreshTimeMillis = 3000L;
        private long automaticCheckpointIntervalMillis = 30000L;
        private int maxOutstandingCheckpointRequest = 3;
        private StreamDataRetention retentionType = StreamDataRetention.NONE;
        private long generation = -1L;
        private UUID readerGroupId = DEFAULT_UUID;

        private ReaderGroupConfigBuilder readerGroupId(UUID initReaderGroupId) {
            this.readerGroupId = initReaderGroupId;
            return this;
        }

        private ReaderGroupConfigBuilder generation(long gen) {
            this.generation = gen;
            return this;
        }

        public ReaderGroupConfigBuilder disableAutomaticCheckpoints() {
            this.automaticCheckpointIntervalMillis = -1L;
            return this;
        }

        public ReaderGroupConfigBuilder stream(String scopedStreamName, StreamCut startStreamCut, StreamCut endStreamCut) {
            Stream stream = Stream.of(scopedStreamName);
            if (this.startingStreamCuts == null) {
                this.startingStreamCuts = new HashMap<Stream, StreamCut>();
            }
            this.startingStreamCuts.put(stream, startStreamCut);
            if (this.endingStreamCuts == null) {
                this.endingStreamCuts = new HashMap<Stream, StreamCut>();
            }
            this.endingStreamCuts.put(stream, endStreamCut);
            return this;
        }

        public ReaderGroupConfigBuilder stream(String scopedStreamName, StreamCut startStreamCut) {
            return this.stream(scopedStreamName, startStreamCut, StreamCut.UNBOUNDED);
        }

        public ReaderGroupConfigBuilder stream(String scopedStreamName) {
            return this.stream(scopedStreamName, StreamCut.UNBOUNDED, StreamCut.UNBOUNDED);
        }

        public ReaderGroupConfigBuilder stream(Stream stream, StreamCut startStreamCut, StreamCut endStreamCut) {
            if (this.startingStreamCuts == null) {
                this.startingStreamCuts = new HashMap<Stream, StreamCut>();
            }
            this.startingStreamCuts.put(stream, startStreamCut);
            if (this.endingStreamCuts == null) {
                this.endingStreamCuts = new HashMap<Stream, StreamCut>();
            }
            this.endingStreamCuts.put(stream, endStreamCut);
            return this;
        }

        public ReaderGroupConfigBuilder stream(Stream stream, StreamCut startStreamCut) {
            return this.stream(stream, startStreamCut, StreamCut.UNBOUNDED);
        }

        public ReaderGroupConfigBuilder stream(Stream stream) {
            return this.stream(stream, StreamCut.UNBOUNDED, StreamCut.UNBOUNDED);
        }

        public ReaderGroupConfigBuilder startFromStreamCuts(Map<Stream, StreamCut> streamCuts) {
            this.startingStreamCuts(streamCuts);
            return this;
        }

        public ReaderGroupConfigBuilder startFromCheckpoint(Checkpoint checkpoint) {
            this.startingStreamCuts(checkpoint.asImpl().getPositions());
            return this;
        }

        public ReaderGroupConfigBuilder retentionType(StreamDataRetention type) {
            this.retentionType = type;
            return this;
        }

        public ReaderGroupConfig build() {
            Preconditions.checkArgument((this.startingStreamCuts != null && this.startingStreamCuts.size() > 0 ? 1 : 0) != 0, (Object)"Stream names that the reader group can read from cannot be empty");
            if (this.endingStreamCuts == null) {
                this.endingStreamCuts = Collections.emptyMap();
            }
            this.validateStreamCut(this.startingStreamCuts);
            this.validateStreamCut(this.endingStreamCuts);
            this.validateStartAndEndStreamCuts(this.startingStreamCuts, this.endingStreamCuts);
            Preconditions.checkArgument((this.maxOutstandingCheckpointRequest > 0 ? 1 : 0) != 0, (Object)"Outstanding checkpoint request should be greater than zero");
            return new ReaderGroupConfig(this.groupRefreshTimeMillis, this.automaticCheckpointIntervalMillis, this.startingStreamCuts, this.endingStreamCuts, this.maxOutstandingCheckpointRequest, this.retentionType, this.generation, this.readerGroupId);
        }

        private void validateStartAndEndStreamCuts(Map<Stream, StreamCut> startStreamCuts, Map<Stream, StreamCut> endStreamCuts) {
            endStreamCuts.entrySet().stream().filter(e -> !((StreamCut)e.getValue()).equals(StreamCut.UNBOUNDED)).forEach(e -> {
                if (startStreamCuts.get(e.getKey()) != StreamCut.UNBOUNDED) {
                    this.verifyStartAndEndStreamCuts((StreamCut)startStreamCuts.get(e.getKey()), (StreamCut)e.getValue());
                }
            });
        }

        private void verifyStartAndEndStreamCuts(StreamCut startStreamCut, StreamCut endStreamCut) {
            Map<Segment, Long> startPositions = startStreamCut.asImpl().getPositions();
            Map<Segment, Long> endPositions = endStreamCut.asImpl().getPositions();
            startPositions.keySet().stream().filter(endPositions::containsKey).forEach(s -> {
                if ((Long)startPositions.get(s) == -1L) {
                    Preconditions.checkArgument(((Long)endPositions.get(s) == -1L ? 1 : 0) != 0, (Object)"Segment offset in startStreamCut should be <= segment offset in endStreamCut");
                } else if ((Long)endPositions.get(s) != -1L) {
                    Preconditions.checkArgument(((Long)startPositions.get(s) <= (Long)endPositions.get(s) ? 1 : 0) != 0, (Object)"Segment offset in startStreamCut should be <= segment offset in endStreamCut.");
                }
            });
            LongSummaryStatistics fromSCSummary = startPositions.keySet().stream().collect(Collectors.summarizingLong(Segment::getSegmentId));
            LongSummaryStatistics toSCSummary = endPositions.keySet().stream().collect(Collectors.summarizingLong(Segment::getSegmentId));
            Preconditions.checkArgument((fromSCSummary.getMin() <= toSCSummary.getMin() ? 1 : 0) != 0, (Object)"Start stream cut must precede end stream cut.");
            Preconditions.checkArgument((fromSCSummary.getMax() <= toSCSummary.getMax() ? 1 : 0) != 0, (Object)"Start stream cut must precede end stream cut.");
        }

        private void validateStreamCut(Map<Stream, StreamCut> streamCuts) {
            streamCuts.forEach((s, streamCut) -> {
                if (!streamCut.equals(StreamCut.UNBOUNDED)) {
                    Preconditions.checkArgument((boolean)s.equals(streamCut.asImpl().getStream()));
                }
            });
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ReaderGroupConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigBuilder groupRefreshTimeMillis(long groupRefreshTimeMillis) {
            this.groupRefreshTimeMillis = groupRefreshTimeMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigBuilder automaticCheckpointIntervalMillis(long automaticCheckpointIntervalMillis) {
            this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigBuilder startingStreamCuts(Map<Stream, StreamCut> startingStreamCuts) {
            this.startingStreamCuts = startingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigBuilder endingStreamCuts(Map<Stream, StreamCut> endingStreamCuts) {
            this.endingStreamCuts = endingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigBuilder maxOutstandingCheckpointRequest(int maxOutstandingCheckpointRequest) {
            this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ReaderGroupConfig.ReaderGroupConfigBuilder(groupRefreshTimeMillis=" + this.groupRefreshTimeMillis + ", automaticCheckpointIntervalMillis=" + this.automaticCheckpointIntervalMillis + ", startingStreamCuts=" + this.startingStreamCuts + ", endingStreamCuts=" + this.endingStreamCuts + ", maxOutstandingCheckpointRequest=" + this.maxOutstandingCheckpointRequest + ", retentionType=" + (Object)((Object)this.retentionType) + ", generation=" + this.generation + ", readerGroupId=" + this.readerGroupId + ")";
        }
    }

    public static enum StreamDataRetention {
        NONE,
        MANUAL_RELEASE_AT_USER_STREAMCUT,
        AUTOMATIC_RELEASE_AT_LAST_CHECKPOINT;

    }
}

