/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.BatchClientFactory;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.impl.StreamCutHelper;
import io.pravega.client.batch.SegmentIterator;
import io.pravega.client.batch.SegmentRange;
import io.pravega.client.batch.StreamSegmentsIterator;
import io.pravega.client.batch.impl.SegmentIteratorImpl;
import io.pravega.client.batch.impl.SegmentRangeImpl;
import io.pravega.client.batch.impl.StreamSegmentsInfoImpl;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentInputStreamFactoryImpl;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.security.auth.AccessOperation;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BatchClientFactoryImpl
implements BatchClientFactory {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchClientFactoryImpl.class);
    private final Controller controller;
    private final ConnectionPool connectionPool;
    private final SegmentInputStreamFactory inputStreamFactory;
    private final SegmentMetadataClientFactory segmentMetadataClientFactory;
    private final StreamCutHelper streamCutHelper;

    public BatchClientFactoryImpl(Controller controller, ClientConfig clientConfig, ConnectionFactory connectionFactory) {
        this.controller = controller;
        this.connectionPool = new ConnectionPoolImpl(clientConfig, connectionFactory);
        this.inputStreamFactory = new SegmentInputStreamFactoryImpl(controller, this.connectionPool);
        this.segmentMetadataClientFactory = new SegmentMetadataClientFactoryImpl(controller, this.connectionPool);
        this.streamCutHelper = new StreamCutHelper(controller, this.connectionPool);
    }

    @Override
    public StreamSegmentsIterator getSegments(Stream stream, StreamCut fromStreamCut, StreamCut toStreamCut) {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        return this.listSegments(stream, Optional.ofNullable(fromStreamCut), Optional.ofNullable(toStreamCut));
    }

    @Override
    public <T> SegmentIterator<T> readSegment(SegmentRange segment, Serializer<T> deserializer) {
        return new SegmentIteratorImpl<T>(this.inputStreamFactory, segment.asImpl().getSegment(), deserializer, segment.asImpl().getStartOffset(), segment.asImpl().getEndOffset());
    }

    private StreamSegmentsIterator listSegments(Stream stream, Optional<StreamCut> startStreamCut, Optional<StreamCut> endStreamCut) {
        Optional<StreamCut> startCut = startStreamCut.filter(sc -> !sc.equals(StreamCut.UNBOUNDED));
        Optional<StreamCut> endCut = endStreamCut.filter(sc -> !sc.equals(StreamCut.UNBOUNDED));
        startCut.ifPresent(streamCut -> Preconditions.checkArgument((boolean)stream.equals(streamCut.asImpl().getStream())));
        endCut.ifPresent(streamCut -> Preconditions.checkArgument((boolean)stream.equals(streamCut.asImpl().getStream())));
        CompletableFuture<StreamCut> startSCFuture = startCut.isPresent() ? CompletableFuture.completedFuture(startCut.get()) : this.streamCutHelper.fetchHeadStreamCut(stream);
        CompletableFuture<StreamCut> endSCFuture = endCut.isPresent() ? CompletableFuture.completedFuture(endCut.get()) : this.streamCutHelper.fetchTailStreamCut(stream);
        return this.getStreamSegmentInfo(stream, startSCFuture.join(), endSCFuture.join());
    }

    private StreamSegmentsIterator getStreamSegmentInfo(Stream stream, StreamCut startStreamCut, StreamCut endStreamCut) {
        log.debug("Start stream cut: {}, End stream cut: {}", (Object)startStreamCut, (Object)endStreamCut);
        StreamSegmentsInfoImpl.validateStreamCuts(startStreamCut, endStreamCut);
        StreamSegmentSuccessors segments = (StreamSegmentSuccessors)Futures.getAndHandleExceptions(this.controller.getSegments(startStreamCut, endStreamCut), RuntimeException::new);
        TreeSet<Segment> segmentSet = new TreeSet<Segment>(segments.getSegments());
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(this.controller, stream.getScope(), stream.getStreamName(), AccessOperation.READ);
        log.debug("List of Segments between the start and end stream cuts : {}", segmentSet);
        List futures = segmentSet.stream().map(s -> this.getSegmentRange((Segment)s, startStreamCut, endStreamCut, tokenProvider)).collect(Collectors.toList());
        List results = (List)Futures.getThrowingException((Future)Futures.allOfWithResults(futures));
        return StreamSegmentsInfoImpl.builder().segmentRangeIterator(results.iterator()).startStreamCut(startStreamCut).endStreamCut(endStreamCut).build();
    }

    private CompletableFuture<SegmentRange> getSegmentRange(Segment segment, StreamCut startStreamCut, StreamCut endStreamCut, DelegationTokenProvider tokenProvider) {
        if (startStreamCut.asImpl().getPositions().containsKey(segment) && endStreamCut.asImpl().getPositions().containsKey(segment)) {
            SegmentRangeImpl.SegmentRangeImplBuilder segmentRangeBuilder = SegmentRangeImpl.builder().segment(segment);
            segmentRangeBuilder.startOffset(startStreamCut.asImpl().getPositions().get(segment)).endOffset(endStreamCut.asImpl().getPositions().get(segment));
            return CompletableFuture.completedFuture(segmentRangeBuilder.build());
        }
        return this.segmentToInfo(segment, tokenProvider).thenApply(r -> {
            SegmentRangeImpl.SegmentRangeImplBuilder segmentRangeBuilder = SegmentRangeImpl.builder().segment(segment);
            segmentRangeBuilder.startOffset(startStreamCut.asImpl().getPositions().getOrDefault(segment, r.getStartingOffset())).endOffset(endStreamCut.asImpl().getPositions().getOrDefault(segment, r.getWriteOffset()));
            return segmentRangeBuilder.build();
        });
    }

    private CompletableFuture<SegmentInfo> segmentToInfo(Segment s, DelegationTokenProvider tokenProvider) {
        SegmentMetadataClient client = this.segmentMetadataClientFactory.createSegmentMetadataClient(s, tokenProvider);
        CompletableFuture<SegmentInfo> result = client.getSegmentInfo();
        result.whenComplete((r, e) -> client.close());
        return result;
    }

    @Override
    public void close() {
        this.controller.close();
        this.connectionPool.close();
    }
}

