/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.util.Counter;
import com.navercorp.pinpoint.profiler.util.Java6Counter;
import java.lang.reflect.Constructor;

public class CounterFactory {
    private static final PLogger logger = PLoggerFactory.getLogger((String)CounterFactory.class.getName());
    private static final ObjectFactory<Counter> counterFactory = CounterFactory.buildFactory();

    private static ObjectFactory<Counter> buildFactory() {
        JvmVersion version = JvmUtils.getVersion();
        if (version.onOrAfter(JvmVersion.JAVA_8)) {
            String counterName = "com.navercorp.pinpoint.profiler.util.Java8CounterFactory";
            try {
                Class<?> counterClazz = Class.forName(counterName, false, CounterFactory.class.getClassLoader());
                Constructor<?> constructor = counterClazz.getDeclaredConstructor(new Class[0]);
                return (ObjectFactory)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.warn("{} not found", (Object)counterName, (Object)e);
            }
        }
        return new Java6CounterFactory();
    }

    public static Counter newCounter() {
        return counterFactory.newInstance();
    }

    private static class Java6CounterFactory
    implements ObjectFactory<Counter> {
        private Java6CounterFactory() {
        }

        @Override
        public Counter newInstance() {
            return new Java6Counter();
        }
    }

    static interface ObjectFactory<T> {
        public T newInstance();
    }
}

