/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformRequestListener;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.RequestHandle;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.ProfilerException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicTransformService
implements DynamicTransformTrigger {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Instrumentation instrumentation;
    private DynamicTransformRequestListener dynamicTransformRequestListener;

    public DynamicTransformService(Instrumentation instrumentation, DynamicTransformRequestListener listener) {
        this.instrumentation = Objects.requireNonNull(instrumentation, "instrumentation");
        this.dynamicTransformRequestListener = Objects.requireNonNull(listener, "listener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retransform(Class<?> target, ClassFileTransformer transformer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retransform request class:{}", (Object)target.getName());
        }
        this.assertClass(target);
        RequestHandle requestHandle = this.dynamicTransformRequestListener.onRetransformRequest(target, transformer);
        boolean success = false;
        try {
            this.triggerRetransform(target);
            success = true;
        }
        finally {
            if (!success) {
                requestHandle.cancel();
            }
        }
    }

    public void addClassFileTransformer(ClassLoader classLoader, String targetClassName, ClassFileTransformer transformer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Add dynamic transform. classLoader={}, class={}", (Object)classLoader, (Object)targetClassName);
        }
        this.dynamicTransformRequestListener.onTransformRequest(classLoader, targetClassName, transformer);
    }

    private void assertClass(Class<?> target) {
        String className;
        if (!this.instrumentation.isModifiableClass(target)) {
            throw new ProfilerException("Target class " + target + " is not modifiable");
        }
        JvmVersion version = JvmUtils.getVersion();
        if (JvmVersion.JAVA_8.compareTo((Enum)version) == 0 && (className = target.getName()) != null && className.contains("$$Lambda$")) {
            throw new ProfilerException("Target class " + target + " is lambda class, Causes NoClassDefFound error in java 8.");
        }
    }

    private void triggerRetransform(Class<?> target) {
        try {
            this.instrumentation.retransformClasses(target);
        }
        catch (UnmodifiableClassException e) {
            throw new ProfilerException(e);
        }
    }

    public void setTransformRequestEventListener(DynamicTransformRequestListener dynamicTransformRequestListener) {
        this.dynamicTransformRequestListener = Objects.requireNonNull(dynamicTransformRequestListener, "dynamicTransformRequestListener");
    }
}

