/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc.metric;

import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.grpc.ExecutorUtils;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzReporter;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporter;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultChannelzScheduledReporter
implements ChannelzScheduledReporter {
    private final ScheduledExecutorService scheduledExecutorService = this.newScheduledExecutorService();
    private final ConcurrentMap<Long, ChannelzReporter> reporterMap = new ConcurrentHashMap<Long, ChannelzReporter>();

    private ScheduledExecutorService newScheduledExecutorService() {
        String threadName = "Pinpoint-" + DefaultChannelzScheduledReporter.class.getSimpleName();
        PinpointThreadFactory threadFactory = new PinpointThreadFactory(threadName, true);
        return new ScheduledThreadPoolExecutor(1, (ThreadFactory)threadFactory);
    }

    @Override
    public void registerRootChannel(final long id, final ChannelzReporter reporter) {
        Objects.requireNonNull(reporter, "reporter");
        ChannelzReporter old = this.reporterMap.putIfAbsent(id, reporter);
        if (old != null) {
            return;
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                reporter.reportRootChannel(id);
            }
        }, 1000L, 60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        ExecutorUtils.shutdownExecutorService((String)"ScheduledReporter", (ExecutorService)this.scheduledExecutorService);
    }
}

