/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.navercorp.pinpoint.grpc.StatusError;
import com.navercorp.pinpoint.grpc.StatusErrors;
import com.navercorp.pinpoint.grpc.client.SupportCommandCodeClientInterceptor;
import com.navercorp.pinpoint.grpc.trace.PCmdMessage;
import com.navercorp.pinpoint.grpc.trace.PCmdRequest;
import com.navercorp.pinpoint.grpc.trace.ProfilerCommandServiceGrpc;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.grpc.CommandServiceStubFactory;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcCommandDispatcher;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamUtils;
import io.grpc.ClientInterceptor;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcCommandService {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final CommandServiceStubFactory commandServiceStubFactory;
    private final ProfilerCommandServiceLocator profilerCommandServiceLocator;
    private final Reconnector reconnector;
    private volatile boolean shutdown;
    private volatile CommandServiceMainStreamObserver commandServiceMainStreamObserver;

    public GrpcCommandService(CommandServiceStubFactory commandServiceStubFactory, ReconnectExecutor reconnectScheduler, ProfilerCommandServiceLocator profilerCommandServiceLocator) {
        this.commandServiceStubFactory = Objects.requireNonNull(commandServiceStubFactory, "commandServiceStubFactory");
        Objects.requireNonNull(reconnectScheduler, "reconnectScheduler");
        this.profilerCommandServiceLocator = Objects.requireNonNull(profilerCommandServiceLocator, "profilerCommandServiceLocator");
        this.reconnector = reconnectScheduler.newReconnector(new Runnable(){

            @Override
            public void run() {
                GrpcCommandService.this.connect();
            }
        });
        this.connect();
    }

    private void connect() {
        this.logger.info("Attempt to connect to CommandServiceStream.");
        if (this.shutdown) {
            return;
        }
        ProfilerCommandServiceGrpc.ProfilerCommandServiceStub profilerCommandServiceStub = this.newCommandServiceStub(this.commandServiceStubFactory, this.profilerCommandServiceLocator);
        GrpcCommandDispatcher commandDispatcher = new GrpcCommandDispatcher(profilerCommandServiceStub, this.profilerCommandServiceLocator);
        CommandServiceMainStreamObserver commandServiceMainStreamObserver = new CommandServiceMainStreamObserver(commandDispatcher);
        profilerCommandServiceStub.handleCommandV2((StreamObserver)commandServiceMainStreamObserver);
        this.commandServiceMainStreamObserver = commandServiceMainStreamObserver;
    }

    private ProfilerCommandServiceGrpc.ProfilerCommandServiceStub newCommandServiceStub(CommandServiceStubFactory commandServiceStubFactory, ProfilerCommandServiceLocator profilerCommandServiceLocator) {
        ProfilerCommandServiceGrpc.ProfilerCommandServiceStub commandServiceStub = commandServiceStubFactory.newStub();
        SupportCommandCodeClientInterceptor supportCommandCodeClientInterceptor = new SupportCommandCodeClientInterceptor(profilerCommandServiceLocator.getCommandServiceCodes());
        return (ProfilerCommandServiceGrpc.ProfilerCommandServiceStub)commandServiceStub.withInterceptors(new ClientInterceptor[]{supportCommandCodeClientInterceptor});
    }

    private void reserveReconnect() {
        this.reconnector.reconnect();
    }

    public void stop() {
        this.logger.info("stop() started");
        if (!this.shutdown) {
            this.shutdown = true;
            CommandServiceMainStreamObserver commandServiceMainStreamObserver = this.commandServiceMainStreamObserver;
            if (commandServiceMainStreamObserver != null) {
                commandServiceMainStreamObserver.stop();
            }
        }
    }

    private class CommandServiceMainStreamObserver
    implements ClientResponseObserver<PCmdMessage, PCmdRequest> {
        private final GrpcCommandDispatcher commandDispatcher;
        private ClientCallStreamObserver<PCmdMessage> requestStream;

        public CommandServiceMainStreamObserver(GrpcCommandDispatcher commandDispatcher) {
            this.commandDispatcher = Objects.requireNonNull(commandDispatcher, "commandDispatcher");
        }

        public void beforeStart(ClientCallStreamObserver<PCmdMessage> requestStream) {
            this.requestStream = requestStream;
            requestStream.setOnReadyHandler(new Runnable(){

                @Override
                public void run() {
                    GrpcCommandService.this.logger.info("Connect to CommandServiceStream completed.");
                    GrpcCommandService.this.reconnector.reset();
                }
            });
        }

        public void onNext(PCmdRequest request) {
            if (GrpcCommandService.this.isDebug) {
                GrpcCommandService.this.logger.debug("received request:{}", (Object)request);
            }
            if (request != null) {
                this.commandDispatcher.handle(request, (StreamObserver<PCmdMessage>)this.requestStream);
            }
        }

        public void onError(Throwable t) {
            StatusError statusError = StatusErrors.throwable((Throwable)t);
            if (statusError.isSimpleError()) {
                GrpcCommandService.this.logger.info("Failed to command stream, cause={}", (Object)statusError.getMessage());
            } else {
                GrpcCommandService.this.logger.warn("Failed to command stream, cause={}", (Object)statusError.getMessage(), (Object)statusError.getThrowable());
            }
            if (this.requestStream != null) {
                this.requestStream.onError(t);
            }
            GrpcCommandService.this.reserveReconnect();
        }

        public void onCompleted() {
            GrpcCommandService.this.logger.info("onCompleted");
            StreamUtils.close(this.requestStream);
            GrpcCommandService.this.reserveReconnect();
        }

        private void stop() {
            GrpcCommandService.this.logger.info("stop");
            StreamUtils.close(this.requestStream);
            this.commandDispatcher.close();
        }
    }
}

